/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.game;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.IIngredient;
import appeng.recipes.game.IRecipeBakeable;
import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class ShapelessRecipe
implements IRecipe,
IRecipeBakeable {
    private final ArrayList<Object> input = new ArrayList();
    private ItemStack output = null;
    private boolean disable = false;

    public ShapelessRecipe(ItemStack result, Object ... recipe) {
        this.output = result.copy();
        for (Object in : recipe) {
            if (!(in instanceof IIngredient)) {
                StringBuilder ret = new StringBuilder("Invalid shapeless ore recipe: ");
                for (Object tmp : recipe) {
                    ret.append(tmp).append(", ");
                }
                ret.append(this.output);
                throw new IllegalArgumentException(ret.toString());
            }
            this.input.add(in);
        }
    }

    public boolean isEnabled() {
        return !this.disable;
    }

    public boolean matches(InventoryCrafting var1, World world) {
        if (this.disable) {
            return false;
        }
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        for (int x = 0; x < var1.getSizeInventory(); ++x) {
            ItemStack slot = var1.getStackInSlot(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            for (Object next : required) {
                boolean match = false;
                if (next instanceof IIngredient) {
                    try {
                        for (ItemStack item : ((IIngredient)next).getItemStackSet()) {
                            match = match || this.checkItemEquals(item, slot);
                        }
                    }
                    catch (RegistrationError e) {
                    }
                    catch (MissingIngredientError e) {
                        // empty catch block
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public ItemStack getCraftingResult(InventoryCrafting var1) {
        return this.output.copy();
    }

    public int getRecipeSize() {
        return this.input.size();
    }

    public ItemStack getRecipeOutput() {
        return this.output;
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        return target.getItem() == input.getItem() && (target.getItemDamage() == Short.MAX_VALUE || target.getItemDamage() == input.getItemDamage());
    }

    public ArrayList<Object> getInput() {
        return this.input;
    }

    @Override
    public void bake() throws RegistrationError {
        try {
            this.disable = false;
            for (Object o : this.input) {
                if (!(o instanceof IIngredient)) continue;
                ((IIngredient)o).bake();
            }
        }
        catch (MissingIngredientError e) {
            this.disable = true;
        }
    }
}

