/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.CondenserOutput;
import appeng.api.config.Settings;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.tile.AEBaseInvTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.util.Iterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileCondenser
extends AEBaseInvTile
implements IFluidHandler,
IConfigManagerHost,
IConfigurableObject {
    private static final FluidTankInfo[] EMPTY = new FluidTankInfo[]{new FluidTankInfo(null, 10)};
    final int[] sides = new int[]{0, 1};
    final AppEngInternalInventory inv = new AppEngInternalInventory(this, 3);
    final ConfigManager cm = new ConfigManager(this);
    public double storedPower = 0.0;

    public TileCondenser() {
        this.cm.registerSetting(Settings.CONDENSER_OUTPUT, (Enum)CondenserOutput.TRASH);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileCondenser(NBTTagCompound data) {
        this.cm.writeToNBT(data);
        data.setDouble("storedPower", this.storedPower);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileCondenser(NBTTagCompound data) {
        this.cm.readFromNBT(data);
        this.storedPower = data.getDouble("storedPower");
    }

    public double getStorage() {
        IStorageComponent sc;
        ItemStack is = this.inv.getStackInSlot(2);
        if (is != null && is.getItem() instanceof IStorageComponent && (sc = (IStorageComponent)is.getItem()).isStorageComponent(is)) {
            return sc.getBytes(is) * 8;
        }
        return 0.0;
    }

    public void addPower(double rawPower) {
        this.storedPower += rawPower;
        this.storedPower = Math.max(0.0, Math.min(this.getStorage(), this.storedPower));
        double requiredPower = this.getRequiredPower();
        ItemStack output = this.getOutput();
        while (requiredPower <= this.storedPower && output != null && requiredPower > 0.0 && this.canAddOutput(output)) {
            this.storedPower -= requiredPower;
            this.addOutput(output);
        }
    }

    private boolean canAddOutput(ItemStack output) {
        ItemStack outputStack = this.getStackInSlot(1);
        return outputStack == null || Platform.isSameItem(outputStack, output) && outputStack.stackSize < outputStack.getMaxStackSize();
    }

    private void addOutput(ItemStack output) {
        ItemStack outputStack = this.getStackInSlot(1);
        if (outputStack == null) {
            this.setInventorySlotContents(1, output.copy());
        } else {
            ++outputStack.stackSize;
            this.setInventorySlotContents(1, outputStack);
        }
    }

    private ItemStack getOutput() {
        IMaterials materials = AEApi.instance().definitions().materials();
        switch ((CondenserOutput)this.cm.getSetting(Settings.CONDENSER_OUTPUT)) {
            case MATTER_BALLS: {
                Iterator i$ = materials.matterBall().maybeStack(1).asSet().iterator();
                if (i$.hasNext()) {
                    ItemStack matterBallStack = (ItemStack)i$.next();
                    return matterBallStack;
                }
            }
            case SINGULARITY: {
                Iterator i$ = materials.singularity().maybeStack(1).asSet().iterator();
                if (!i$.hasNext()) break;
                ItemStack singularityStack = (ItemStack)i$.next();
                return singularityStack;
            }
        }
        return null;
    }

    public double getRequiredPower() {
        return ((CondenserOutput)this.cm.getSetting((Settings)Settings.CONDENSER_OUTPUT)).requiredPower;
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        if (i == 0) {
            if (itemstack != null) {
                this.addPower(itemstack.stackSize);
            }
        } else {
            this.inv.setInventorySlotContents(1, itemstack);
        }
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return i == 0;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        ItemStack is;
        if (slot == 0 && (is = inv.getStackInSlot(0)) != null) {
            this.addPower(is.stackSize);
            inv.setInventorySlotContents(0, null);
        }
    }

    @Override
    public boolean canInsertItem(int slotIndex, ItemStack insertingItem, int side) {
        return slotIndex == 0;
    }

    @Override
    public boolean canExtractItem(int slotIndex, ItemStack extractedItem, int side) {
        return slotIndex != 0;
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (doFill) {
            this.addPower((resource == null ? 0.0 : (double)resource.amount) / 500.0);
        }
        return resource == null ? 0 : resource.amount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return EMPTY;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.addPower(0.0);
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }
}

