/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAETagCompound;
import appeng.util.Platform;
import appeng.util.item.AEItemDef;
import appeng.util.item.AESharedNBT;
import appeng.util.item.AEStack;
import appeng.util.item.OreHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class AEItemStack
extends AEStack<IAEItemStack>
implements IAEItemStack,
Comparable<AEItemStack> {
    AEItemDef def;

    private AEItemStack(AEItemStack is) {
        this.def = is.def;
        this.stackSize = is.stackSize;
        this.setCraftable(is.isCraftable());
        this.setCountRequestable(is.getCountRequestable());
    }

    private AEItemStack(ItemStack is) {
        if (is == null) {
            throw new InvalidParameterException("null is not a valid ItemStack for AEItemStack.");
        }
        Item item = is.getItem();
        if (item == null) {
            throw new InvalidParameterException("Contained item is null, thus not a valid ItemStack for AEItemStack.");
        }
        this.def = new AEItemDef(item);
        if (this.def.item == null) {
            throw new InvalidParameterException("This ItemStack is bad, it has a null item.");
        }
        this.def.damageValue = this.def.getDamageValueHack(is);
        this.def.displayDamage = is.getItemDamageForDisplay();
        this.def.maxDamage = is.getMaxDamage();
        NBTTagCompound tagCompound = is.getTagCompound();
        if (tagCompound != null) {
            this.def.tagCompound = (AESharedNBT)AESharedNBT.getSharedTagCompound(tagCompound, is);
        }
        this.stackSize = is.stackSize;
        this.setCraftable(false);
        this.setCountRequestable(0L);
        this.def.reHash();
        this.def.isOre = OreHelper.INSTANCE.isOre(is);
    }

    public static IAEItemStack loadItemStackFromNBT(NBTTagCompound i) {
        if (i == null) {
            return null;
        }
        ItemStack itemstack = ItemStack.loadItemStackFromNBT((NBTTagCompound)i);
        if (itemstack == null) {
            return null;
        }
        AEItemStack item = AEItemStack.create(itemstack);
        item.stackSize = i.getLong("Cnt");
        item.setCountRequestable(i.getLong("Req"));
        item.setCraftable(i.getBoolean("Craft"));
        return item;
    }

    @Nullable
    public static AEItemStack create(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return new AEItemStack(stack);
    }

    public static IAEItemStack loadItemStackFromPacket(ByteBuf data) throws IOException {
        byte mask = data.readByte();
        byte StackType = (byte)((mask & 0xC) >> 2);
        byte CountReqType = (byte)((mask & 0x30) >> 4);
        boolean isCraftable = (mask & 0x40) > 0;
        boolean hasTagCompound = (mask & 0x80) > 0;
        NBTTagCompound d = new NBTTagCompound();
        d.setShort("id", data.readShort());
        d.setShort("Damage", data.readShort());
        d.setByte("Count", (byte)0);
        if (hasTagCompound) {
            int len = data.readInt();
            byte[] bd = new byte[len];
            data.readBytes(bd);
            ByteArrayInputStream di = new ByteArrayInputStream(bd);
            d.setTag("tag", (NBTBase)CompressedStreamTools.read((DataInputStream)new DataInputStream(di)));
        }
        long stackSize = AEItemStack.getPacketValue(StackType, data);
        long countRequestable = AEItemStack.getPacketValue(CountReqType, data);
        ItemStack itemstack = ItemStack.loadItemStackFromNBT((NBTTagCompound)d);
        if (itemstack == null) {
            return null;
        }
        AEItemStack item = AEItemStack.create(itemstack);
        item.stackSize = stackSize;
        item.setCountRequestable(countRequestable);
        item.setCraftable(isCraftable);
        return item;
    }

    @Override
    public void add(IAEItemStack option) {
        if (option == null) {
            return;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    @Override
    public void writeToNBT(NBTTagCompound i) {
        i.setShort("id", (short)Item.itemRegistry.getIDForObject((Object)this.def.item));
        i.setByte("Count", (byte)0);
        i.setLong("Cnt", this.stackSize);
        i.setLong("Req", this.getCountRequestable());
        i.setBoolean("Craft", this.isCraftable());
        i.setShort("Damage", (short)this.def.damageValue);
        if (this.def.tagCompound != null) {
            i.setTag("tag", (NBTBase)this.def.tagCompound);
        } else {
            i.removeTag("tag");
        }
    }

    @Override
    public boolean fuzzyComparison(Object st, FuzzyMode Mode) {
        IAEItemStack o;
        if (st instanceof IAEItemStack) {
            o = (IAEItemStack)st;
            if (this.sameOre(o)) {
                return true;
            }
            if (o.getItem() == this.getItem()) {
                if (this.def.item.isDamageable()) {
                    ItemStack a = this.getItemStack();
                    ItemStack b = o.getItemStack();
                    try {
                        if (Mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (Mode == FuzzyMode.PERCENT_99) {
                            return a.getItemDamageForDisplay() > 1 == b.getItemDamageForDisplay() > 1;
                        }
                        float APercentDamaged = 1.0f - (float)a.getItemDamageForDisplay() / (float)a.getMaxDamage();
                        float BPercentDamaged = 1.0f - (float)b.getItemDamageForDisplay() / (float)b.getMaxDamage();
                        return APercentDamaged > Mode.breakPoint == BPercentDamaged > Mode.breakPoint;
                    }
                    catch (Throwable e) {
                        if (Mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (Mode == FuzzyMode.PERCENT_99) {
                            return a.getItemDamage() > 1 == b.getItemDamage() > 1;
                        }
                        float APercentDamaged = (float)a.getItemDamage() / (float)a.getMaxDamage();
                        float BPercentDamaged = (float)b.getItemDamage() / (float)b.getMaxDamage();
                        return APercentDamaged > Mode.breakPoint == BPercentDamaged > Mode.breakPoint;
                    }
                }
                return this.getItemDamage() == o.getItemDamage();
            }
        }
        if (st instanceof ItemStack) {
            o = (ItemStack)st;
            OreHelper.INSTANCE.sameOre(this, (ItemStack)o);
            if (o.getItem() == this.getItem()) {
                if (this.def.item.isDamageable()) {
                    ItemStack a = this.getItemStack();
                    try {
                        if (Mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (Mode == FuzzyMode.PERCENT_99) {
                            return a.getItemDamageForDisplay() > 1 == o.getItemDamageForDisplay() > 1;
                        }
                        float APercentDamaged = 1.0f - (float)a.getItemDamageForDisplay() / (float)a.getMaxDamage();
                        float BPercentDamaged = 1.0f - (float)o.getItemDamageForDisplay() / (float)o.getMaxDamage();
                        return APercentDamaged > Mode.breakPoint == BPercentDamaged > Mode.breakPoint;
                    }
                    catch (Throwable e) {
                        if (Mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (Mode == FuzzyMode.PERCENT_99) {
                            return a.getItemDamage() > 1 == o.getItemDamage() > 1;
                        }
                        float APercentDamaged = (float)a.getItemDamage() / (float)a.getMaxDamage();
                        float BPercentDamaged = (float)o.getItemDamage() / (float)o.getMaxDamage();
                        return APercentDamaged > Mode.breakPoint == BPercentDamaged > Mode.breakPoint;
                    }
                }
                return this.getItemDamage() == o.getItemDamage();
            }
        }
        return false;
    }

    @Override
    public IAEItemStack copy() {
        return new AEItemStack(this);
    }

    @Override
    public IAEItemStack empty() {
        IAEItemStack dup = this.copy();
        dup.reset();
        return dup;
    }

    @Override
    public IAETagCompound getTagCompound() {
        return this.def.tagCompound;
    }

    @Override
    public boolean isItem() {
        return true;
    }

    @Override
    public boolean isFluid() {
        return false;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack is = new ItemStack(this.def.item, (int)Math.min(Integer.MAX_VALUE, this.stackSize), this.def.damageValue);
        if (this.def.tagCompound != null) {
            is.setTagCompound(this.def.tagCompound.getNBTTagCompoundCopy());
        }
        return is;
    }

    @Override
    public Item getItem() {
        return this.def.item;
    }

    @Override
    public int getItemDamage() {
        return this.def.damageValue;
    }

    @Override
    public boolean sameOre(IAEItemStack is) {
        return OreHelper.INSTANCE.sameOre(this, is);
    }

    @Override
    public boolean isSameType(IAEItemStack otherStack) {
        if (otherStack == null) {
            return false;
        }
        return this.def.equals(((AEItemStack)otherStack).def);
    }

    @Override
    public boolean isSameType(ItemStack otherStack) {
        if (otherStack == null) {
            return false;
        }
        return this.def.isItem(otherStack);
    }

    public int hashCode() {
        return this.def.myHash;
    }

    @Override
    public boolean equals(Object ia) {
        ItemStack is;
        if (ia instanceof AEItemStack) {
            return ((AEItemStack)ia).def.equals(this.def);
        }
        if (ia instanceof ItemStack && (is = (ItemStack)ia).getItem() == this.def.item && is.getItemDamage() == this.def.damageValue) {
            AESharedNBT ta = this.def.tagCompound;
            NBTTagCompound tb = is.getTagCompound();
            if (ta == tb) {
                return true;
            }
            if (ta == null && tb == null || ta != null && ta.hasNoTags() && tb == null || tb != null && tb.hasNoTags() && ta == null || ta != null && ta.hasNoTags() && tb != null && tb.hasNoTags()) {
                return true;
            }
            if (ta == null && tb != null || ta != null && tb == null) {
                return false;
            }
            if (AESharedNBT.isShared(tb)) {
                return ta == tb;
            }
            return Platform.NBTEqualityTest((NBTBase)ta, (NBTBase)tb);
        }
        return false;
    }

    public String toString() {
        return this.getItemStack().toString();
    }

    @Override
    public int compareTo(AEItemStack b) {
        int id = this.def.itemID - b.def.itemID;
        if (id != 0) {
            return id;
        }
        int damageValue = this.def.damageValue - b.def.damageValue;
        if (damageValue != 0) {
            return damageValue;
        }
        int displayDamage = this.def.displayDamage - b.def.displayDamage;
        if (displayDamage != 0) {
            return displayDamage;
        }
        return this.def.tagCompound == b.def.tagCompound ? 0 : this.compareNBT(b.def);
    }

    private int compareNBT(AEItemDef b) {
        int nbt = this.compare(this.def.tagCompound == null ? 0 : this.def.tagCompound.getHash(), b.tagCompound == null ? 0 : b.tagCompound.getHash());
        if (nbt == 0) {
            return this.compare(System.identityHashCode(this.def.tagCompound), System.identityHashCode(b.tagCompound));
        }
        return nbt;
    }

    private int compare(int l, int m) {
        return l < m ? -1 : (l > m ? 1 : 0);
    }

    @SideOnly(value=Side.CLIENT)
    public List getToolTip() {
        if (this.def.tooltip != null) {
            return this.def.tooltip;
        }
        this.def.tooltip = Platform.getTooltip(this.getItemStack());
        return this.def.tooltip;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        if (this.def.displayName != null) {
            return this.def.displayName;
        }
        this.def.displayName = Platform.getItemDisplayName(this.getItemStack());
        return this.def.displayName;
    }

    @SideOnly(value=Side.CLIENT)
    public String getModID() {
        if (this.def.uniqueID != null) {
            return this.getModName(this.def.uniqueID);
        }
        this.def.uniqueID = GameRegistry.findUniqueIdentifierFor((Item)this.def.item);
        return this.getModName(this.def.uniqueID);
    }

    private String getModName(GameRegistry.UniqueIdentifier uniqueIdentifier) {
        if (uniqueIdentifier == null) {
            return "** Null";
        }
        return uniqueIdentifier.modId == null ? "** Null" : uniqueIdentifier.modId;
    }

    public IAEItemStack getLow(FuzzyMode fuzzy, boolean ignoreMeta) {
        AEItemStack bottom = new AEItemStack(this);
        AEItemDef newDef = bottom.def = bottom.def.copy();
        if (ignoreMeta) {
            newDef.damageValue = 0;
            newDef.displayDamage = 0;
            newDef.reHash();
            return bottom;
        }
        if (newDef.item.isDamageable()) {
            int breakpoint;
            newDef.displayDamage = fuzzy == FuzzyMode.IGNORE_ALL ? 0 : (fuzzy == FuzzyMode.PERCENT_99 ? (this.def.damageValue == 0 ? 0 : 1) : ((breakpoint = fuzzy.calculateBreakPoint(this.def.maxDamage)) <= this.def.displayDamage ? breakpoint : 0));
            newDef.damageValue = newDef.displayDamage;
        }
        newDef.tagCompound = AEItemDef.LOW_TAG;
        newDef.reHash();
        return bottom;
    }

    public IAEItemStack getHigh(FuzzyMode fuzzy, boolean ignoreMeta) {
        AEItemStack top = new AEItemStack(this);
        AEItemDef newDef = top.def = top.def.copy();
        if (ignoreMeta) {
            newDef.damageValue = Integer.MAX_VALUE;
            newDef.displayDamage = Integer.MAX_VALUE;
            newDef.reHash();
            return top;
        }
        if (newDef.item.isDamageable()) {
            int breakpoint;
            newDef.displayDamage = fuzzy == FuzzyMode.IGNORE_ALL ? this.def.maxDamage + 1 : (fuzzy == FuzzyMode.PERCENT_99 ? (this.def.damageValue == 0 ? 0 : this.def.maxDamage + 1) : (this.def.displayDamage < (breakpoint = fuzzy.calculateBreakPoint(this.def.maxDamage)) ? breakpoint - 1 : this.def.maxDamage + 1));
            newDef.damageValue = newDef.displayDamage;
        }
        newDef.tagCompound = AEItemDef.HIGH_TAG;
        newDef.reHash();
        return top;
    }

    public boolean isOre() {
        return this.def.isOre != null;
    }

    @Override
    void writeIdentity(ByteBuf i) throws IOException {
        i.writeShort(Item.itemRegistry.getIDForObject((Object)this.def.item));
        i.writeShort(this.getItemDamage());
    }

    @Override
    void readNBT(ByteBuf i) throws IOException {
        if (this.hasTagCompound()) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            CompressedStreamTools.write((NBTTagCompound)((NBTTagCompound)this.getTagCompound()), (DataOutput)data);
            byte[] tagBytes = bytes.toByteArray();
            int size = tagBytes.length;
            i.writeInt(size);
            i.writeBytes(tagBytes);
        }
    }

    @Override
    public boolean hasTagCompound() {
        return this.def.tagCompound != null;
    }
}

