/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IBlockDefinition;
import appeng.block.AEBaseBlock;
import appeng.core.features.ActivityState;
import appeng.core.features.ItemDefinition;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Constructor;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class BlockDefinition
extends ItemDefinition
implements IBlockDefinition {
    private final Block block;
    private final boolean enabled;

    public BlockDefinition(Block block, ActivityState state) {
        super(BlockDefinition.constructItemFromBlock(block), state);
        Preconditions.checkNotNull((Object)block);
        Preconditions.checkNotNull((Object)((Object)state));
        this.block = block;
        this.enabled = state == ActivityState.Enabled;
    }

    @Override
    public final Optional<Block> maybeBlock() {
        return Optional.of((Object)this.block);
    }

    @Override
    public final Optional<ItemBlock> maybeItemBlock() {
        if (this.enabled) {
            return Optional.of((Object)new ItemBlock(this.block));
        }
        return Optional.absent();
    }

    @Override
    public final Optional<ItemStack> maybeStack(int stackSize) {
        if (this.enabled) {
            return Optional.of((Object)new ItemStack(this.block));
        }
        return Optional.absent();
    }

    @Override
    public final boolean isSameAs(IBlockAccess world, int x, int y, int z) {
        return this.enabled && world.func_147439_a(x, y, z) == this.block;
    }

    private static Item constructItemFromBlock(Block block) {
        Class<? extends ItemBlock> itemclass = BlockDefinition.getItemBlockConstructor(block);
        return BlockDefinition.constructItemBlock(block, itemclass);
    }

    private static Class<? extends ItemBlock> getItemBlockConstructor(Block block) {
        if (block instanceof AEBaseBlock) {
            AEBaseBlock aeBaseBlock = (AEBaseBlock)block;
            return aeBaseBlock.getItemBlockClass();
        }
        return ItemBlock.class;
    }

    private static Item constructItemBlock(Block block, Class<? extends ItemBlock> itemclass) {
        try {
            Object[] itemCtorArgs = new Object[]{};
            Class[] ctorArgClasses = new Class[itemCtorArgs.length + 1];
            ctorArgClasses[0] = Block.class;
            for (int idx = 1; idx < ctorArgClasses.length; ++idx) {
                ctorArgClasses[idx] = itemCtorArgs[idx - 1].getClass();
            }
            Constructor<? extends ItemBlock> itemCtor = itemclass.getConstructor(ctorArgClasses);
            return (Item)itemCtor.newInstance(ObjectArrays.concat((Object)block, (Object[])itemCtorArgs));
        }
        catch (Throwable t) {
            return null;
        }
    }
}

