/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.util.DimensionalCoord;
import appeng.block.misc.BlockTinyTNT;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.hooks.DispenserBlockTool;
import appeng.hooks.IBlockTool;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.InWorldToolOperationResult;
import appeng.util.Platform;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ToolEntropyManipulator
extends AEBasePoweredItem
implements IBlockTool {
    private final Map<InWorldToolOperationIngredient, InWorldToolOperationResult> heatUp;
    private final Map<InWorldToolOperationIngredient, InWorldToolOperationResult> coolDown;

    public ToolEntropyManipulator() {
        super(AEConfig.instance.entropyManipulatorBattery, (Optional<String>)Optional.absent());
        this.setFeature(EnumSet.of(AEFeature.EntropyManipulator, AEFeature.PoweredTools));
        this.heatUp = new HashMap<InWorldToolOperationIngredient, InWorldToolOperationResult>();
        this.coolDown = new HashMap<InWorldToolOperationIngredient, InWorldToolOperationResult>();
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.field_150348_b, 0), new InWorldToolOperationResult(new ItemStack(Blocks.field_150347_e)));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.field_150417_aV, 0), new InWorldToolOperationResult(new ItemStack(Blocks.field_150417_aV, 1, 2)));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.field_150353_l, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.field_150343_Z)));
        this.coolDown.put(new InWorldToolOperationIngredient((Block)Blocks.field_150356_k, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.field_150343_Z)));
        this.coolDown.put(new InWorldToolOperationIngredient((Block)Blocks.field_150349_c, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.field_150346_d)));
        ArrayList<ItemStack> snowBalls = new ArrayList<ItemStack>();
        snowBalls.add(new ItemStack(Items.field_151126_ay));
        this.coolDown.put(new InWorldToolOperationIngredient((Block)Blocks.field_150358_i, Short.MAX_VALUE), new InWorldToolOperationResult(null, snowBalls));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.field_150355_j, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.field_150432_aD)));
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.field_150432_aD, 0), new InWorldToolOperationResult(new ItemStack(Blocks.field_150355_j)));
        this.heatUp.put(new InWorldToolOperationIngredient((Block)Blocks.field_150358_i, Short.MAX_VALUE), new InWorldToolOperationResult());
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.field_150355_j, Short.MAX_VALUE), new InWorldToolOperationResult());
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.field_150433_aE, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack((Block)Blocks.field_150358_i)));
    }

    @Override
    public void postInit() {
        super.postInit();
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new DispenserBlockTool());
    }

    private void heat(Block blockID, int metadata, World w, int x, int y, int z) {
        InWorldToolOperationResult r = this.heatUp.get(new InWorldToolOperationIngredient(blockID, metadata));
        if (r == null) {
            r = this.heatUp.get(new InWorldToolOperationIngredient(blockID, Short.MAX_VALUE));
        }
        if (r.BlockItem != null) {
            w.func_147465_d(x, y, z, Block.func_149634_a((Item)r.BlockItem.func_77973_b()), r.BlockItem.func_77960_j(), 3);
        } else {
            w.func_147465_d(x, y, z, Platform.AIR, 0, 3);
        }
        if (r.Drops != null) {
            Platform.spawnDrops(w, x, y, z, r.Drops);
        }
    }

    private boolean canHeat(Block blockID, int metadata) {
        InWorldToolOperationResult r = this.heatUp.get(new InWorldToolOperationIngredient(blockID, metadata));
        if (r == null) {
            r = this.heatUp.get(new InWorldToolOperationIngredient(blockID, Short.MAX_VALUE));
        }
        return r != null;
    }

    private void cool(Block blockID, int metadata, World w, int x, int y, int z) {
        InWorldToolOperationResult r = this.coolDown.get(new InWorldToolOperationIngredient(blockID, metadata));
        if (r == null) {
            r = this.coolDown.get(new InWorldToolOperationIngredient(blockID, Short.MAX_VALUE));
        }
        if (r.BlockItem != null) {
            w.func_147465_d(x, y, z, Block.func_149634_a((Item)r.BlockItem.func_77973_b()), r.BlockItem.func_77960_j(), 3);
        } else {
            w.func_147465_d(x, y, z, Platform.AIR, 0, 3);
        }
        if (r.Drops != null) {
            Platform.spawnDrops(w, x, y, z, r.Drops);
        }
    }

    private boolean canCool(Block blockID, int metadata) {
        InWorldToolOperationResult r = this.coolDown.get(new InWorldToolOperationIngredient(blockID, metadata));
        if (r == null) {
            r = this.coolDown.get(new InWorldToolOperationIngredient(blockID, Short.MAX_VALUE));
        }
        return r != null;
    }

    public boolean func_77644_a(ItemStack item, EntityLivingBase target, EntityLivingBase hitter) {
        if (this.getAECurrentPower(item) > 1600.0) {
            this.extractAEPower(item, 1600.0);
            target.func_70015_d(8);
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack item, World w, EntityPlayer p) {
        int z;
        int y;
        int x;
        MovingObjectPosition target = this.func_77621_a(w, p, true);
        if (target == null) {
            return item;
        }
        if (target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (w.func_147439_a(x = target.field_72311_b, y = target.field_72312_c, z = target.field_72309_d).func_149688_o() == Material.field_151587_i || w.func_147439_a(x, y, z).func_149688_o() == Material.field_151586_h) && Platform.hasPermissions(new DimensionalCoord(w, x, y, z), p)) {
            this.func_77648_a(item, p, w, x, y, z, 0, 0.0f, 0.0f, 0.0f);
        }
        return item;
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer p, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (this.getAECurrentPower(item) > 1600.0) {
            if (!p.func_82247_a(x, y, z, side, item)) {
                return false;
            }
            Block blockID = w.func_147439_a(x, y, z);
            int metadata = w.func_72805_g(x, y, z);
            if (p.func_70093_af()) {
                if (this.canCool(blockID, metadata)) {
                    this.extractAEPower(item, 1600.0);
                    this.cool(blockID, metadata, w, x, y, z);
                    return true;
                }
            } else {
                if (blockID instanceof BlockTNT) {
                    w.func_147465_d(x, y, z, Platform.AIR, 0, 3);
                    ((BlockTNT)blockID).func_150114_a(w, x, y, z, 1, (EntityLivingBase)p);
                    return true;
                }
                if (blockID instanceof BlockTinyTNT) {
                    w.func_147465_d(x, y, z, Platform.AIR, 0, 3);
                    ((BlockTinyTNT)blockID).startFuse(w, x, y, z, (EntityLivingBase)p);
                    return true;
                }
                if (this.canHeat(blockID, metadata)) {
                    this.extractAEPower(item, 1600.0);
                    this.heat(blockID, metadata, w, x, y, z);
                    return true;
                }
                ItemStack[] stack = Platform.getBlockDrops(w, x, y, z);
                ArrayList<ItemStack> out = new ArrayList<ItemStack>();
                boolean hasFurnaceable = false;
                boolean canFurnaceable = true;
                for (ItemStack i : stack) {
                    ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(i);
                    if (result != null) {
                        if (result.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)result.func_77973_b()) == blockID && result.func_77973_b().getDamage(result) == metadata) {
                            canFurnaceable = false;
                        }
                        hasFurnaceable = true;
                        out.add(result);
                        continue;
                    }
                    canFurnaceable = false;
                    out.add(i);
                }
                if (hasFurnaceable && canFurnaceable) {
                    this.extractAEPower(item, 1600.0);
                    InWorldToolOperationResult or = InWorldToolOperationResult.getBlockOperationResult(out.toArray(new ItemStack[out.size()]));
                    w.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    if (or.BlockItem == null) {
                        w.func_147465_d(x, y, z, Platform.AIR, 0, 3);
                    } else {
                        w.func_147465_d(x, y, z, Block.func_149634_a((Item)or.BlockItem.func_77973_b()), or.BlockItem.func_77960_j(), 3);
                    }
                    if (or.Drops != null) {
                        Platform.spawnDrops(w, x, y, z, or.Drops);
                    }
                    return true;
                }
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                if (!p.func_82247_a(x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ, side, item)) {
                    return false;
                }
                if (w.func_147437_c(x, y, z)) {
                    this.extractAEPower(item, 1600.0);
                    w.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    w.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
                }
                return true;
            }
        }
        return false;
    }

    private static class InWorldToolOperationIngredient {
        private final Block blockID;
        private final int metadata;

        public InWorldToolOperationIngredient(Block blockID, int metadata) {
            this.blockID = blockID;
            this.metadata = metadata;
        }

        public int hashCode() {
            return this.blockID.hashCode() ^ this.metadata;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InWorldToolOperationIngredient other = (InWorldToolOperationIngredient)obj;
            return this.blockID == other.blockID && this.metadata == other.metadata;
        }
    }
}

