/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes;

import appeng.api.AEApi;
import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RecipeError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.IIngredient;
import appeng.api.recipes.ResolverResult;
import appeng.api.recipes.ResolverResultSet;
import appeng.recipes.MissedIngredientSet;
import appeng.recipes.RecipeHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class Ingredient
implements IIngredient {
    public final boolean isAir;
    public final String nameSpace;
    public final String itemName;
    public final int meta;
    public final int qty;
    NBTTagCompound nbt = null;
    ItemStack[] baked;

    public Ingredient(RecipeHandler handler, String input, int qty) throws RecipeError, MissedIngredientSet {
        String tmpName;
        this.qty = qty;
        if (input.equals("_")) {
            this.isAir = true;
            this.nameSpace = "";
            this.itemName = "";
            this.meta = Short.MAX_VALUE;
            return;
        }
        this.isAir = false;
        String[] parts = input.split(":");
        if (parts.length >= 2) {
            this.nameSpace = handler.alias(parts[0]);
            tmpName = handler.alias(parts[1]);
            if (parts.length != 3) {
                int sel = 0;
                if (this.nameSpace.equals("oreDictionary")) {
                    if (parts.length == 3) {
                        throw new RecipeError("Cannot specify meta when using ore dictionary.");
                    }
                    sel = Short.MAX_VALUE;
                } else {
                    try {
                        Object ro = AEApi.instance().registries().recipes().resolveItem(this.nameSpace, tmpName);
                        if (ro instanceof ResolverResult) {
                            ResolverResult rr = (ResolverResult)ro;
                            tmpName = rr.itemName;
                            sel = rr.damageValue;
                            this.nbt = rr.compound;
                        } else if (ro instanceof ResolverResultSet) {
                            throw new MissedIngredientSet((ResolverResultSet)ro);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new RecipeError(tmpName + " is not a valid ae2 item definition.");
                    }
                }
                this.meta = sel;
            } else if (parts[2].equals("*")) {
                this.meta = Short.MAX_VALUE;
            } else {
                try {
                    this.meta = Integer.parseInt(parts[2]);
                }
                catch (NumberFormatException e) {
                    throw new RecipeError("Invalid Metadata.");
                }
            }
        } else {
            throw new RecipeError(input + " : Needs at least Namespace and Name.");
        }
        this.itemName = tmpName;
        handler.data.knownItem.add(this.toString());
    }

    public String toString() {
        return this.nameSpace + ':' + this.itemName + ':' + this.meta;
    }

    @Override
    public ItemStack getItemStack() throws RegistrationError, MissingIngredientError {
        Item it;
        if (this.isAir) {
            throw new RegistrationError("Found blank item and expected a real item.");
        }
        if (this.nameSpace.equalsIgnoreCase("oreDictionary")) {
            throw new RegistrationError("Recipe format expected a single item, but got a set of items.");
        }
        Block blk = GameRegistry.findBlock((String)this.nameSpace, (String)this.itemName);
        if (blk == null) {
            blk = GameRegistry.findBlock((String)this.nameSpace, (String)("tile." + this.itemName));
        }
        if (blk != null && (it = Item.func_150898_a((Block)blk)) != null) {
            return this.MakeItemStack(it, this.qty, this.meta, this.nbt);
        }
        it = GameRegistry.findItem((String)this.nameSpace, (String)this.itemName);
        if (it == null) {
            it = GameRegistry.findItem((String)this.nameSpace, (String)("item." + this.itemName));
        }
        if (it != null) {
            return this.MakeItemStack(it, this.qty, this.meta, this.nbt);
        }
        throw new MissingIngredientError("Unable to find item: " + this.toString());
    }

    private ItemStack MakeItemStack(Item it, int quantity, int damageValue, NBTTagCompound compound) {
        ItemStack is = new ItemStack(it, quantity, damageValue);
        is.func_77982_d(compound);
        return is;
    }

    @Override
    public ItemStack[] getItemStackSet() throws RegistrationError, MissingIngredientError {
        if (this.baked != null) {
            return this.baked;
        }
        if (this.nameSpace.equalsIgnoreCase("oreDictionary")) {
            ArrayList ores = OreDictionary.getOres((String)this.itemName);
            ItemStack[] set = ores.toArray(new ItemStack[ores.size()]);
            for (int x = 0; x < set.length; ++x) {
                ItemStack is = set[x].func_77946_l();
                is.field_77994_a = this.qty;
                set[x] = is;
            }
            if (set.length == 0) {
                throw new MissingIngredientError(this.itemName + " - ore dictionary could not be resolved to any items.");
            }
            return set;
        }
        return new ItemStack[]{this.getItemStack()};
    }

    @Override
    public String getNameSpace() {
        return this.nameSpace;
    }

    @Override
    public String getItemName() {
        return this.itemName;
    }

    @Override
    public int getDamageValue() {
        return this.meta;
    }

    @Override
    public int getQty() {
        return this.qty;
    }

    @Override
    public boolean isAir() {
        return this.isAir;
    }

    @Override
    public void bake() throws RegistrationError, MissingIngredientError {
        this.baked = null;
        this.baked = this.getItemStackSet();
    }
}

