/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.compass;

import appeng.core.AELog;
import appeng.services.compass.CompassException;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class CompassRegion {
    final int low_x;
    final int low_z;
    final int hi_x;
    final int hi_z;
    final int world;
    final File rootFolder;
    boolean hasFile = false;
    RandomAccessFile raf = null;
    ByteBuffer buffer;

    public CompassRegion(int cx, int cz, int worldID, File rootFolder) {
        this.world = worldID;
        this.rootFolder = rootFolder;
        int region_x = cx >> 10;
        int region_z = cz >> 10;
        this.low_x = region_x << 10;
        this.low_z = region_z << 10;
        this.hi_x = this.low_x + 1024;
        this.hi_z = this.low_z + 1024;
        this.openFile(false);
    }

    private void openFile(boolean create) {
        File fName = this.getFileName();
        if (this.hasFile) {
            return;
        }
        if (create || this.fileExists(fName)) {
            try {
                this.raf = new RandomAccessFile(fName, "rw");
                FileChannel fc = this.raf.getChannel();
                this.buffer = fc.map(FileChannel.MapMode.READ_WRITE, 0L, 0x100000L);
                this.hasFile = true;
            }
            catch (Throwable t) {
                throw new CompassException(t);
            }
        }
    }

    private File getFileName() {
        String folder = this.rootFolder.getPath() + File.separatorChar + "compass";
        File folderFile = new File(folder);
        if (!(folderFile.exists() && folderFile.isDirectory() || folderFile.mkdir())) {
            AELog.info("Failed to create AE2/compass/", new Object[0]);
        }
        return new File(folder, this.world + 95 + this.low_x + 95 + this.low_z + ".dat");
    }

    private boolean fileExists(File name) {
        return name.exists() && name.isFile();
    }

    public void close() {
        try {
            if (this.hasFile) {
                this.buffer = null;
                this.raf.close();
                this.raf = null;
                this.hasFile = false;
            }
        }
        catch (Throwable t) {
            throw new CompassException(t);
        }
    }

    public boolean hasBeacon(int cx, int cz) {
        int val;
        return this.hasFile && (val = this.read(cx &= 0x3FF, cz &= 0x3FF)) != 0;
    }

    private int read(int cx, int cz) {
        try {
            return this.buffer.get(cx + cz * 1024);
        }
        catch (IndexOutOfBoundsException outOfBounds) {
            return 0;
        }
        catch (Throwable t) {
            throw new CompassException(t);
        }
    }

    public void setHasBeacon(int cx, int cz, int cdy, boolean hasBeacon) {
        cx &= 0x3FF;
        cz &= 0x3FF;
        this.openFile(hasBeacon);
        if (this.hasFile) {
            int val;
            int originalVal = val = this.read(cx, cz);
            val = hasBeacon ? (val |= 1 << cdy) : (val &= ~(1 << cdy));
            if (originalVal != val) {
                this.write(cx, cz, val);
            }
        }
    }

    private void write(int cx, int cz, int val) {
        try {
            this.buffer.put(cx + cz * 1024, (byte)val);
        }
        catch (Throwable t) {
            throw new CompassException(t);
        }
    }
}

