/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.version;

import appeng.services.version.Channel;
import appeng.services.version.DefaultVersion;
import appeng.services.version.Version;
import java.util.Scanner;
import java.util.regex.Pattern;

public final class VersionParser {
    private static final Pattern PATTERN_DOT = Pattern.compile("\\.");
    private static final Pattern PATTERN_DASH = Pattern.compile("-");
    private static final Pattern PATTERN_REVISION = Pattern.compile("[^0-9]+");
    private static final Pattern PATTERN_BUILD = Pattern.compile("[^0-9]+");
    private static final Pattern PATTERN_NATURAL = Pattern.compile("[0-9]+");
    private static final Pattern PATTERN_VALID_REVISION = Pattern.compile("^rv\\d+$");

    public Version parse(String raw) {
        String transformed = this.transformDelimiter(raw);
        String[] split = transformed.split("_");
        return this.parseVersion(split);
    }

    private String transformDelimiter(String raw) {
        assert (raw.contains(".") || raw.contains("-"));
        String withoutDot = PATTERN_DOT.matcher(raw).replaceAll("_");
        String withoutDash = PATTERN_DASH.matcher(withoutDot).replaceAll("_");
        return withoutDash;
    }

    private Version parseVersion(String[] splitRaw) {
        assert (splitRaw.length == 3);
        String rawRevision = splitRaw[0];
        String rawChannel = splitRaw[1];
        String rawBuild = splitRaw[2];
        int revision = this.parseRevision(rawRevision);
        Channel channel = this.parseChannel(rawChannel);
        int build = this.parseBuild(rawBuild);
        return new DefaultVersion(revision, channel, build);
    }

    private int parseRevision(String rawRevision) {
        assert (PATTERN_VALID_REVISION.matcher(rawRevision).matches());
        int revision = new Scanner(rawRevision).useDelimiter(PATTERN_REVISION).nextInt();
        return revision;
    }

    private Channel parseChannel(String rawChannel) {
        assert (rawChannel.equalsIgnoreCase(Channel.Alpha.name()) || rawChannel.equalsIgnoreCase(Channel.Beta.name()) || rawChannel.equalsIgnoreCase(Channel.Release.name()));
        for (Channel channel : Channel.values()) {
            if (!channel.name().equalsIgnoreCase(rawChannel)) continue;
            return channel;
        }
        throw new IllegalArgumentException("Raw channel " + rawChannel + " did not contain any of the pre-programmed types.");
    }

    private int parseBuild(String rawBuild) {
        assert (PATTERN_NATURAL.matcher(rawBuild).matches());
        int build = new Scanner(rawBuild).useDelimiter(PATTERN_BUILD).nextInt();
        return build;
    }
}

