/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AEColor;
import appeng.tile.TileEvent;
import appeng.tile.crafting.TileCraftingTile;
import appeng.tile.events.TileEventType;
import appeng.util.item.AEItemStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCraftingMonitorTile
extends TileCraftingTile
implements IColorableTile {
    @SideOnly(value=Side.CLIENT)
    public Integer dspList;
    @SideOnly(value=Side.CLIENT)
    public boolean updateList;
    IAEItemStack dspPlay;
    AEColor paintedColor = AEColor.Transparent;

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileCraftingMonitorTile(ByteBuf data) throws IOException {
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        boolean hasItem = data.readBoolean();
        this.dspPlay = hasItem ? AEItemStack.loadItemStackFromPacket(data) : null;
        this.updateList = true;
        return oldPaintedColor != this.paintedColor;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileCraftingMonitorTile(ByteBuf data) throws IOException {
        data.writeByte(this.paintedColor.ordinal());
        if (this.dspPlay == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            this.dspPlay.writeToPacket(data);
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileCraftingMonitorTile(NBTTagCompound data) {
        if (data.func_74764_b("paintedColor")) {
            this.paintedColor = AEColor.values()[data.func_74771_c("paintedColor")];
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileCraftingMonitorTile(NBTTagCompound data) {
        data.func_74774_a("paintedColor", (byte)this.paintedColor.ordinal());
    }

    @Override
    public boolean isAccelerator() {
        return false;
    }

    @Override
    public boolean isStatus() {
        return true;
    }

    public void setJob(IAEItemStack is) {
        if (is == null != (this.dspPlay == null)) {
            this.dspPlay = is == null ? null : is.copy();
            this.markForUpdate();
        } else if (is != null && this.dspPlay != null && is.getStackSize() != this.dspPlay.getStackSize()) {
            this.dspPlay = is.copy();
            this.markForUpdate();
        }
    }

    public IAEItemStack getJobProgress() {
        return this.dspPlay;
    }

    @Override
    public boolean requiresTESR() {
        return this.dspPlay != null;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(ForgeDirection side, AEColor newPaintedColor, EntityPlayer who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.func_70296_d();
        this.markForUpdate();
        return true;
    }
}

