/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.config;

import appeng.api.definitions.IItemDefinition;
import appeng.api.util.AEItemDefinition;
import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public enum Upgrades {
    CAPACITY(0),
    REDSTONE(0),
    CRAFTING(0),
    FUZZY(1),
    SPEED(1),
    INVERTER(1),
    PATTERN_CAPACITY(1),
    ORE_FILTER(1);

    @Deprecated
    public final int tier;
    @Deprecated
    private final Map<ItemStack, Integer> supportedMax = new HashMap<ItemStack, Integer>();

    private Upgrades(int tier) {
        this.tier = tier;
    }

    public Map<ItemStack, Integer> getSupported() {
        return this.supportedMax;
    }

    public void registerItem(IItemDefinition item, int maxSupported) {
        Optional<ItemStack> maybeStack = item.maybeStack(1);
        for (ItemStack stack : maybeStack.asSet()) {
            this.registerItem(stack, maxSupported);
        }
    }

    public void registerItem(ItemStack stack, int maxSupported) {
        if (stack != null) {
            this.supportedMax.put(stack, maxSupported);
        }
    }

    @Deprecated
    public void registerItem(AEItemDefinition item, int maxSupported) {
        ItemStack stack;
        if (item != null && (stack = item.stack(1)) != null) {
            this.registerItem(stack, maxSupported);
        }
    }

    public int getTier() {
        return this.tier;
    }
}

