/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.core.settings.TickRates;
import appeng.integration.IntegrationType;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.transformer.annotations.Integration;
import appeng.util.Platform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.block.BlockSupplier;
import pneumaticCraft.api.tileentity.AirHandlerSupplier;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.api.tileentity.ISidedPneumaticMachine;

@Integration.Interface(iface="pneumaticCraft.api.tileentity.ISidedPneumaticMachine", iname=IntegrationType.PneumaticCraft)
public final class PartP2PPressure
extends PartP2PTunnel<PartP2PPressure>
implements ISidedPneumaticMachine,
IGridTickable {
    private static final String PRESSURE_NBT_TAG = "pneumaticCraft";
    private static final String PRESSURE_TYPE_ICON_NAME = "compressedIronBlock";
    private static final float MAX_PRESSURE = 30.0f;
    private static final int VOLUME = 1000;
    @Nonnull
    private final IAirHandler handler = AirHandlerSupplier.getAirHandler((float)30.0f, (float)30.0f, (int)1000);
    private boolean isConnected = false;
    private boolean isValid = false;

    public PartP2PPressure(ItemStack is) {
        super(is);
    }

    @Override
    protected IIcon getTypeTexture() {
        return BlockSupplier.getBlock((String)PRESSURE_TYPE_ICON_NAME).getIcon(0, 0);
    }

    @Nullable
    public IAirHandler getAirHandler(ForgeDirection side) {
        if (side == this.getSide()) {
            return this.getInternalHandler();
        }
        return null;
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        if (this.isValid) {
            this.getInternalHandler().onNeighborChange();
        }
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.getInternalHandler().validateI(this.getTile());
        this.isValid = true;
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.isValid = false;
        if (this.isOutput() && this.getInput() != null) {
            this.getInternalHandler().removeConnection(((PartP2PPressure)this.getInput()).getInternalHandler());
            this.isConnected = false;
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.PressureTunnel.getMin(), TickRates.PressureTunnel.getMax(), false, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (this.getProxy().isPowered() && this.getProxy().isActive()) {
            if (!this.isConnected) {
                this.updateHandler();
            }
            this.getInternalHandler().updateEntityI();
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.IDLE;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        NBTTagCompound pneumaticNBT = new NBTTagCompound();
        this.getInternalHandler().writeToNBTI(pneumaticNBT);
        data.setTag(PRESSURE_NBT_TAG, (NBTBase)pneumaticNBT);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.getInternalHandler().readFromNBTI(data.getCompoundTag(PRESSURE_NBT_TAG));
    }

    @Nonnull
    private IAirHandler getInternalHandler() {
        return this.handler;
    }

    private void updateHandler() {
        if (this.getProxy().isPowered() && this.getProxy().isActive()) {
            if (this.isOutput() && this.getInput() != null) {
                this.getInternalHandler().createConnection(((PartP2PPressure)this.getInput()).getInternalHandler());
                this.isConnected = true;
            }
            TileEntity te = this.getTile();
            Platform.notifyBlocksOfNeighbors(te.getWorldObj(), te.xCoord, te.yCoord, te.zCoord);
        }
    }
}

