/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen;

import appeng.api.features.IWorldGen;
import appeng.core.AEConfig;
import appeng.core.features.registries.WorldGenRegistry;
import appeng.core.worlddata.WorldData;
import appeng.hooks.TickHandler;
import appeng.util.IWorldCallable;
import appeng.util.Platform;
import appeng.worldgen.MeteoritePlacer;
import appeng.worldgen.meteorite.ChunkOnly;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public final class MeteoriteWorldGen
implements IWorldGenerator {
    public void generate(Random r, int chunkX, int chunkZ, World w, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (WorldGenRegistry.INSTANCE.isWorldGenEnabled(IWorldGen.WorldGenType.Meteorites, w)) {
            if ((double)r.nextFloat() < AEConfig.instance.meteoriteSpawnChance) {
                int x = r.nextInt(16) + (chunkX << 4);
                int z = r.nextInt(16) + (chunkZ << 4);
                int depth = 180 + r.nextInt(20);
                TickHandler.INSTANCE.addCallable(w, new MeteoriteSpawn(x, depth, z));
            } else {
                TickHandler.INSTANCE.addCallable(w, new MeteoriteSpawn(chunkX << 4, 128, chunkZ << 4));
            }
        } else {
            WorldData.instance().compassData().service().updateArea(w, chunkX, chunkZ);
        }
    }

    private boolean tryMeteorite(World w, int depth, int x, int z) {
        for (int tries = 0; tries < 20; ++tries) {
            MeteoritePlacer mp = new MeteoritePlacer();
            if (mp.spawnMeteorite(new ChunkOnly(w, x >> 4, z >> 4), x, depth, z)) {
                int px = x >> 4;
                int pz = z >> 4;
                for (int cx = px - 6; cx < px + 6; ++cx) {
                    for (int cz = pz - 6; cz < pz + 6; ++cz) {
                        if (!w.getChunkProvider().chunkExists(cx, cz) || px == cx && pz == cz || !WorldData.instance().spawnData().hasGenerated(w.provider.dimensionId, cx, cz)) continue;
                        MeteoritePlacer mp2 = new MeteoritePlacer();
                        mp2.spawnMeteorite(new ChunkOnly(w, cx, cz), mp.getSettings());
                    }
                }
                return true;
            }
            if ((depth -= 15) >= 40) continue;
            return false;
        }
        return false;
    }

    private Iterable<NBTTagCompound> getNearByMeteorites(World w, int chunkX, int chunkZ) {
        return WorldData.instance().spawnData().getNearByMeteorites(w.provider.dimensionId, chunkX, chunkZ);
    }

    private class MeteoriteSpawn
    implements IWorldCallable<Object> {
        private final int x;
        private final int z;
        private final int depth;

        public MeteoriteSpawn(int x, int depth, int z) {
            this.x = x;
            this.z = z;
            this.depth = depth;
        }

        @Override
        public Object call(World world) throws Exception {
            boolean isCluster;
            int chunkX = this.x >> 4;
            int chunkZ = this.z >> 4;
            double minSqDist = Double.MAX_VALUE;
            for (NBTTagCompound data : MeteoriteWorldGen.this.getNearByMeteorites(world, chunkX, chunkZ)) {
                MeteoritePlacer mp = new MeteoritePlacer();
                mp.spawnMeteorite(new ChunkOnly(world, chunkX, chunkZ), data);
                minSqDist = Math.min(minSqDist, mp.getSqDistance(this.x, this.z));
            }
            boolean bl = isCluster = minSqDist < 900.0 && (double)Platform.getRandomFloat() < AEConfig.instance.meteoriteClusterChance;
            if (minSqDist > (double)AEConfig.instance.minMeteoriteDistanceSq || isCluster) {
                MeteoriteWorldGen.this.tryMeteorite(world, this.depth, this.x, this.z);
            }
            WorldData.instance().spawnData().setGenerated(world.provider.dimensionId, chunkX, chunkZ);
            WorldData.instance().compassData().service().updateArea(world, chunkX, chunkZ);
            return null;
        }
    }
}

