/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.game;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.IIngredient;
import appeng.recipes.game.IRecipeBakeable;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class ShapedRecipe
implements IRecipe,
IRecipeBakeable {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    private ItemStack output = null;
    private Object[] input = null;
    private int width = 0;
    private int height = 0;
    private boolean mirrored = true;
    private boolean disable = false;

    public ShapedRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        StringBuilder shape = new StringBuilder();
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx];
            ++idx;
            for (String s : parts) {
                this.width = s.length();
                shape.append(s);
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx];
                ++idx;
                shape.append(s);
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            StringBuilder ret = new StringBuilder("Invalid shaped ore recipe: ");
            for (Object tmp : recipe) {
                ret.append(tmp).append(", ");
            }
            ret.append(this.output);
            throw new IllegalStateException(ret.toString());
        }
        HashMap<Character, IIngredient> itemMap = new HashMap<Character, IIngredient>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (!(in instanceof IIngredient)) {
                StringBuilder ret = new StringBuilder("Invalid shaped ore recipe: ");
                for (Object tmp : recipe) {
                    ret.append(tmp).append(", ");
                }
                ret.append(this.output);
                throw new IllegalStateException(ret.toString());
            }
            itemMap.put(chr, (IIngredient)in);
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toString().toCharArray()) {
            this.input[x] = itemMap.get(Character.valueOf(chr));
            ++x;
        }
    }

    public boolean isEnabled() {
        return !this.disable;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        if (this.disable) {
            return false;
        }
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        if (this.disable) {
            return false;
        }
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                boolean matched;
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof IIngredient) {
                    matched = false;
                    try {
                        for (ItemStack item : ((IIngredient)target).getItemStackSet()) {
                            matched = matched || this.checkItemEquals(item, slot);
                        }
                    }
                    catch (RegistrationError registrationError) {
                    }
                    catch (MissingIngredientError missingIngredientError) {
                        // empty catch block
                    }
                    if (matched) continue;
                    return false;
                }
                if (target instanceof ArrayList) {
                    matched = false;
                    for (ItemStack item : (Iterable)target) {
                        matched = matched || this.checkItemEquals(item, slot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.func_77973_b() == input.func_77973_b() && (target.func_77960_j() == Short.MAX_VALUE || target.func_77960_j() == input.func_77960_j());
    }

    public ShapedRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Object[] getIngredients() {
        return this.input;
    }

    @Override
    public void bake() throws RegistrationError {
        try {
            this.disable = false;
            for (Object o : this.input) {
                if (!(o instanceof IIngredient)) continue;
                ((IIngredient)o).bake();
            }
        }
        catch (MissingIngredientError err) {
            this.disable = true;
        }
    }
}

