/*
 * Decompiled with CFR 0.152.
 */
package appeng.services;

import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.services.version.ModVersionFetcher;
import appeng.services.version.Version;
import appeng.services.version.VersionCheckerConfig;
import appeng.services.version.VersionParser;
import appeng.services.version.github.FormattedRelease;
import appeng.services.version.github.ReleaseFetcher;
import com.google.common.base.Preconditions;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.Date;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;

public final class VersionChecker
implements Runnable {
    private static final int SEC_TO_HOUR = 3600;
    private static final int MS_TO_SEC = 1000;
    private final VersionCheckerConfig config;

    public VersionChecker(@Nonnull VersionCheckerConfig config) {
        Preconditions.checkNotNull((Object)config);
        this.config = config;
    }

    @Override
    public void run() {
        try {
            Thread.yield();
            this.config.save();
            String rawLastCheck = this.config.lastCheck();
            long lastCheck = Long.parseLong(rawLastCheck);
            Date now = new Date();
            long nowInMs = now.getTime();
            long intervalInMs = this.config.interval() * 3600 * 1000;
            long lastAfterInterval = lastCheck + intervalInMs;
            this.processInterval(nowInMs, lastAfterInterval);
        }
        catch (Exception exception) {
            AELog.debug(exception);
        }
        AELog.info("Stopping AE2 VersionChecker", new Object[0]);
    }

    private void processInterval(long nowInMs, long lastAfterInterval) {
        if (nowInMs > lastAfterInterval) {
            String rawModVersion = "rv3-beta-46-GTNH";
            VersionParser parser = new VersionParser();
            ModVersionFetcher modFetcher = new ModVersionFetcher("rv3-beta-46-GTNH", parser);
            ReleaseFetcher githubFetcher = new ReleaseFetcher(this.config, parser);
            Version modVersion = modFetcher.get();
            FormattedRelease githubRelease = githubFetcher.get();
            this.processVersions(modVersion, githubRelease);
        } else {
            AELog.info("Last check was just recently.", new Object[0]);
        }
    }

    private void processVersions(@Nonnull Version modVersion, @Nonnull FormattedRelease githubRelease) {
        Version githubVersion = githubRelease.version();
        String modFormatted = modVersion.formatted();
        String ghFormatted = githubVersion.formatted();
        if (githubVersion.isNewerAs(modVersion)) {
            String changelog = githubRelease.changelog();
            if (this.config.shouldNotifyPlayer()) {
                AELog.info("Newer version is available: " + ghFormatted + " (found) > " + modFormatted + " (current)", new Object[0]);
                if (this.config.shouldPostChangelog()) {
                    AELog.info("Changelog: " + changelog, new Object[0]);
                }
            }
            this.interactWithVersionCheckerMod(modFormatted, ghFormatted, changelog);
        } else {
            AELog.info("No newer version is available: " + ghFormatted + "(found) < " + modFormatted + " (current)", new Object[0]);
        }
    }

    private void interactWithVersionCheckerMod(@Nonnull String modFormatted, @Nonnull String ghFormatted, @Nonnull String changelog) {
        if (Loader.isModLoaded((String)"VersionChecker")) {
            NBTTagCompound versionInf = new NBTTagCompound();
            versionInf.func_74778_a("modDisplayName", "Applied Energistics 2");
            versionInf.func_74778_a("oldVersion", modFormatted);
            versionInf.func_74778_a("newVersion", ghFormatted);
            versionInf.func_74778_a("updateUrl", "https://github.com/xsun2001/Applied-Energistics-2-Unofficial/releases/download/rv3.beta.13/appliedenergistics2" + ghFormatted + ".jar");
            versionInf.func_74757_a("isDirectLink", true);
            if (!changelog.isEmpty()) {
                versionInf.func_74778_a("changeLog", changelog);
            }
            versionInf.func_74778_a("newFileName", "appliedenergistics2-" + ghFormatted + ".jar");
            FMLInterModComms.sendRuntimeMessage((Object)AppEng.instance(), (String)"VersionChecker", (String)"addUpdate", (NBTTagCompound)versionInf);
            AELog.info("Reported new version to VersionChecker mod.", new Object[0]);
        } else {
            AELog.info("VersionChecker mod is not installed; Proceeding.", new Object[0]);
        }
    }
}

