/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.client.render.BusRenderHelper;
import appeng.client.render.BusRenderer;
import appeng.client.render.RenderBlocksWorkaround;
import appeng.parts.BusCollisionHelper;
import appeng.parts.CableBusContainer;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class CableRenderHelper {
    private static final CableRenderHelper INSTANCE = new CableRenderHelper();

    public static CableRenderHelper getInstance() {
        return INSTANCE;
    }

    public void renderStatic(CableBusContainer cableBusContainer, IFacadeContainer iFacadeContainer) {
        TileEntity te = cableBusContainer.getTile();
        RenderBlocksWorkaround renderer = BusRenderer.INSTANCE.getRenderer();
        if (renderer.overrideBlockTexture != null) {
            BusRenderHelper.INSTANCE.setPass(0);
        }
        if (renderer.blockAccess == null) {
            renderer.blockAccess = Minecraft.getMinecraft().theWorld;
        }
        for (ForgeDirection s : ForgeDirection.values()) {
            IPart part = cableBusContainer.getPart(s);
            if (part == null) continue;
            this.setSide(s);
            renderer.renderAllFaces = true;
            renderer.flipTexture = false;
            renderer.uvRotateWest = 0;
            renderer.uvRotateTop = 0;
            renderer.uvRotateSouth = 0;
            renderer.uvRotateNorth = 0;
            renderer.uvRotateEast = 0;
            renderer.uvRotateBottom = 0;
            part.renderStatic(te.xCoord, te.yCoord, te.zCoord, BusRenderHelper.INSTANCE, renderer);
            renderer.setFaces(EnumSet.allOf(ForgeDirection.class));
            renderer.setCalculations(true);
            renderer.setUseTextures(true);
        }
        if (!iFacadeContainer.isEmpty()) {
            ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
            for (ForgeDirection s : ForgeDirection.values()) {
                IPart part = cableBusContainer.getPart(s);
                if (part == null) continue;
                this.setSide(s);
                BusRenderHelper brh = BusRenderHelper.INSTANCE;
                BusCollisionHelper bch = new BusCollisionHelper(boxes, brh.getWorldX(), brh.getWorldY(), brh.getWorldZ(), null, true);
                part.getBoxes(bch);
            }
            boolean useThinFacades = false;
            double min = 0.125;
            double max = 0.875;
            for (AxisAlignedBB bb : boxes) {
                int o = 0;
                o += bb.maxX > 0.875 ? 1 : 0;
                o += bb.maxY > 0.875 ? 1 : 0;
                o += bb.maxZ > 0.875 ? 1 : 0;
                o += bb.minX < 0.125 ? 1 : 0;
                o += bb.minY < 0.125 ? 1 : 0;
                if ((o += bb.minZ < 0.125 ? 1 : 0) < 2) continue;
                useThinFacades = true;
            }
            for (ForgeDirection s : ForgeDirection.VALID_DIRECTIONS) {
                IFacadePart fPart = iFacadeContainer.getFacade(s);
                if (fPart == null) continue;
                fPart.setThinFacades(useThinFacades);
                AxisAlignedBB pb = fPart.getPrimaryBox();
                AxisAlignedBB b = null;
                for (AxisAlignedBB bb : boxes) {
                    if (!bb.intersectsWith(pb)) continue;
                    if (b == null) {
                        b = bb;
                        continue;
                    }
                    b.maxX = Math.max(b.maxX, bb.maxX);
                    b.maxY = Math.max(b.maxY, bb.maxY);
                    b.maxZ = Math.max(b.maxZ, bb.maxZ);
                    b.minX = Math.min(b.minX, bb.minX);
                    b.minY = Math.min(b.minY, bb.minY);
                    b.minZ = Math.min(b.minZ, bb.minZ);
                }
                renderer.flipTexture = false;
                renderer.uvRotateWest = 0;
                renderer.uvRotateTop = 0;
                renderer.uvRotateSouth = 0;
                renderer.uvRotateNorth = 0;
                renderer.uvRotateEast = 0;
                renderer.uvRotateBottom = 0;
                this.setSide(s);
                fPart.renderStatic(te.xCoord, te.yCoord, te.zCoord, BusRenderHelper.INSTANCE, renderer, iFacadeContainer, b, cableBusContainer.getPart(s) == null);
            }
            renderer.setFacade(false);
            renderer.enableAO = false;
            renderer.setTexture(null);
            renderer.setCalculations(true);
        }
    }

    private void setSide(ForgeDirection s) {
        ForgeDirection az;
        ForgeDirection ay;
        ForgeDirection ax;
        switch (s) {
            case DOWN: {
                ax = ForgeDirection.EAST;
                ay = ForgeDirection.NORTH;
                az = ForgeDirection.DOWN;
                break;
            }
            case UP: {
                ax = ForgeDirection.EAST;
                ay = ForgeDirection.SOUTH;
                az = ForgeDirection.UP;
                break;
            }
            case EAST: {
                ax = ForgeDirection.SOUTH;
                ay = ForgeDirection.UP;
                az = ForgeDirection.EAST;
                break;
            }
            case WEST: {
                ax = ForgeDirection.NORTH;
                ay = ForgeDirection.UP;
                az = ForgeDirection.WEST;
                break;
            }
            case NORTH: {
                ax = ForgeDirection.WEST;
                ay = ForgeDirection.UP;
                az = ForgeDirection.NORTH;
                break;
            }
            case SOUTH: {
                ax = ForgeDirection.EAST;
                ay = ForgeDirection.UP;
                az = ForgeDirection.SOUTH;
                break;
            }
            default: {
                ax = ForgeDirection.EAST;
                ay = ForgeDirection.UP;
                az = ForgeDirection.SOUTH;
            }
        }
        BusRenderHelper.INSTANCE.setOrientation(ax, ay, az);
    }

    public void renderDynamic(CableBusContainer cableBusContainer, double x, double y, double z) {
        for (ForgeDirection s : ForgeDirection.values()) {
            ForgeDirection az;
            ForgeDirection ay;
            ForgeDirection ax;
            IPart part = cableBusContainer.getPart(s);
            if (part == null) continue;
            switch (s) {
                case DOWN: {
                    ax = ForgeDirection.EAST;
                    ay = ForgeDirection.NORTH;
                    az = ForgeDirection.DOWN;
                    break;
                }
                case UP: {
                    ax = ForgeDirection.EAST;
                    ay = ForgeDirection.SOUTH;
                    az = ForgeDirection.UP;
                    break;
                }
                case EAST: {
                    ax = ForgeDirection.SOUTH;
                    ay = ForgeDirection.UP;
                    az = ForgeDirection.EAST;
                    break;
                }
                case WEST: {
                    ax = ForgeDirection.NORTH;
                    ay = ForgeDirection.UP;
                    az = ForgeDirection.WEST;
                    break;
                }
                case NORTH: {
                    ax = ForgeDirection.WEST;
                    ay = ForgeDirection.UP;
                    az = ForgeDirection.NORTH;
                    break;
                }
                case SOUTH: {
                    ax = ForgeDirection.EAST;
                    ay = ForgeDirection.UP;
                    az = ForgeDirection.SOUTH;
                    break;
                }
                default: {
                    ax = ForgeDirection.EAST;
                    ay = ForgeDirection.UP;
                    az = ForgeDirection.SOUTH;
                }
            }
            BusRenderHelper.INSTANCE.setOrientation(ax, ay, az);
            part.renderDynamic(x, y, z, BusRenderHelper.INSTANCE, BusRenderer.INSTANCE.getRenderer());
        }
    }
}

