/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.items;

import appeng.api.util.AEColor;
import appeng.client.texture.ExtraItemTextures;
import appeng.items.misc.ItemPaintBall;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class PaintBallRender
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        IIcon par2Icon = item.getItemDamage() < 20 ? item.getIconIndex() : ExtraItemTextures.ItemPaintBallShimmer.getIcon();
        float f4 = par2Icon.getMinU();
        float f5 = par2Icon.getMaxU();
        float f6 = par2Icon.getMinV();
        float f7 = par2Icon.getMaxV();
        ItemPaintBall ipb = (ItemPaintBall)item.getItem();
        Tessellator tessellator = Tessellator.instance;
        GL11.glPushMatrix();
        AEColor col = ipb.getColor(item);
        int colorValue = item.getItemDamage() >= 20 ? col.mediumVariant : col.mediumVariant;
        int r = colorValue >> 16 & 0xFF;
        int g = colorValue >> 8 & 0xFF;
        int b = colorValue & 0xFF;
        if (item.getItemDamage() >= 20) {
            float fail = 0.7f;
            int full = 76;
            GL11.glColor4ub((byte)((byte)(76.0f + (float)r * 0.7f)), (byte)((byte)(76.0f + (float)g * 0.7f)), (byte)((byte)(76.0f + (float)b * 0.7f)), (byte)-1);
        } else {
            GL11.glColor4ub((byte)((byte)r), (byte)((byte)g), (byte)((byte)b), (byte)-1);
        }
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScalef((float)16.0f, (float)16.0f, (float)10.0f);
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glEnable((int)3008);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, (double)f4, (double)f7);
            tessellator.addVertexWithUV(1.0, 0.0, 0.0, (double)f5, (double)f7);
            tessellator.addVertexWithUV(1.0, 1.0, 0.0, (double)f5, (double)f6);
            tessellator.addVertexWithUV(0.0, 1.0, 0.0, (double)f4, (double)f6);
            tessellator.draw();
        } else {
            if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
            } else {
                GL11.glTranslatef((float)-0.5f, (float)-0.3f, (float)0.01f);
            }
            float f12 = 0.0625f;
            ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)f5, (float)f6, (float)f4, (float)f7, (int)par2Icon.getIconWidth(), (int)par2Icon.getIconHeight(), (float)0.0625f);
            GL11.glDisable((int)2884);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.1f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)1.07f, (float)-0.03125f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glDisable((int)3008);
        } else {
            GL11.glEnable((int)2884);
        }
        GL11.glPopMatrix();
    }
}

