/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IBlockDefinition;
import appeng.block.AEBaseBlock;
import appeng.core.CreativeTab;
import appeng.core.features.AEFeature;
import appeng.core.features.ActivityState;
import appeng.core.features.BlockDefinition;
import appeng.core.features.FeatureNameExtractor;
import appeng.core.features.FeaturedActiveChecker;
import appeng.core.features.IFeatureHandler;
import com.google.common.base.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public final class AEBlockFeatureHandler
implements IFeatureHandler {
    private final AEBaseBlock featured;
    private final FeatureNameExtractor extractor;
    private final boolean enabled;
    private final BlockDefinition definition;

    public AEBlockFeatureHandler(EnumSet<AEFeature> features, AEBaseBlock featured, Optional<String> subName) {
        ActivityState state = new FeaturedActiveChecker(features).getActivityState();
        this.featured = featured;
        this.extractor = new FeatureNameExtractor(featured.getClass(), subName);
        this.enabled = state == ActivityState.Enabled;
        this.definition = new BlockDefinition(featured, state);
    }

    @Override
    public boolean isFeatureAvailable() {
        return this.enabled;
    }

    @Override
    public IBlockDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void register() {
        if (this.enabled) {
            String name = this.extractor.get();
            this.featured.setCreativeTab(CreativeTab.instance);
            this.featured.setBlockName("appliedenergistics2." + name);
            this.featured.setBlockTextureName("appliedenergistics2:" + name);
            String registryName = "tile." + name;
            GameRegistry.registerBlock((Block)this.featured, null, (String)registryName);
            GameRegistry.registerItem((Item)((Item)this.definition.maybeItem().get()), (String)registryName);
        }
    }
}

