/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.pathfinding;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.me.cache.PathGridCache;
import appeng.me.pathfinding.IPathItem;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PathSegment {
    private final PathGridCache pgc;
    private final Set<IPathItem> semiOpen;
    private final Set<IPathItem> closed;
    private boolean isDead;
    private List<IPathItem> open;

    public PathSegment(PathGridCache myPGC, List<IPathItem> open, Set<IPathItem> semiOpen, Set<IPathItem> closed) {
        this.open = open;
        this.semiOpen = semiOpen;
        this.closed = closed;
        this.pgc = myPGC;
        this.setDead(false);
    }

    public boolean step() {
        List<IPathItem> oldOpen = this.open;
        this.open = new LinkedList<IPathItem>();
        for (IPathItem i : oldOpen) {
            for (IPathItem pi : i.getPossibleOptions()) {
                EnumSet<GridFlags> flags = pi.getFlags();
                if (this.closed.contains(pi)) continue;
                pi.setControllerRoute(i, true);
                if (flags.contains((Object)GridFlags.REQUIRE_CHANNEL)) {
                    if (!this.semiOpen.contains(pi)) {
                        boolean worked = flags.contains((Object)GridFlags.COMPRESSED_CHANNEL) ? this.useDenseChannel(pi) : this.useChannel(pi);
                        if (worked && flags.contains((Object)GridFlags.MULTIBLOCK)) {
                            Iterator<IGridNode> oni = ((IGridMultiblock)((IGridNode)((Object)pi)).getGridBlock()).getMultiblockNodes();
                            while (oni.hasNext()) {
                                IGridNode otherNodes = oni.next();
                                if (otherNodes == pi) continue;
                                this.semiOpen.add((IPathItem)((Object)otherNodes));
                            }
                        }
                    } else {
                        pi.incrementChannelCount(1);
                        this.semiOpen.remove(pi);
                    }
                }
                this.closed.add(pi);
                this.open.add(pi);
            }
        }
        return this.open.isEmpty();
    }

    private boolean useDenseChannel(IPathItem start) {
        IPathItem pi;
        for (pi = start; pi != null; pi = pi.getControllerRoute()) {
            if (pi.canSupportMoreChannels() && !pi.getFlags().contains((Object)GridFlags.CANNOT_CARRY_COMPRESSED)) continue;
            return false;
        }
        for (pi = start; pi != null; pi = pi.getControllerRoute()) {
            this.pgc.setChannelsByBlocks(this.pgc.getChannelsByBlocks() + 1);
            pi.incrementChannelCount(1);
        }
        this.pgc.setChannelsInUse(this.pgc.getChannelsInUse() + 1);
        return true;
    }

    private boolean useChannel(IPathItem start) {
        IPathItem pi;
        for (pi = start; pi != null; pi = pi.getControllerRoute()) {
            if (pi.canSupportMoreChannels()) continue;
            return false;
        }
        for (pi = start; pi != null; pi = pi.getControllerRoute()) {
            this.pgc.setChannelsByBlocks(this.pgc.getChannelsByBlocks() + 1);
            pi.incrementChannelCount(1);
        }
        this.pgc.setChannelsInUse(this.pgc.getChannelsInUse() + 1);
        return true;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public void setDead(boolean isDead) {
        this.isDead = isDead;
    }
}

