/*
 * This file is part of Applied Energistics 2.
 * Copyright (c) 2013 - 2014, AlgorithmX2, All rights reserved.
 *
 * Applied Energistics 2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Applied Energistics 2 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Applied Energistics 2.  If not, see <http://www.gnu.org/licenses/lgpl>.
 */

package appeng.integration.modules.NEIHelpers;


import appeng.client.gui.implementations.GuiCraftingTerm;
import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketNEIRecipe;
import appeng.util.Platform;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;


public class NEICraftingHandler implements IOverlayHandler
{

	public NEICraftingHandler( final int x, final int y )
	{
	}

	@Override
	public void overlayRecipe( final GuiContainer gui, final IRecipeHandler recipe, final int recipeIndex, final boolean shift )
	{
		try
		{
			final List<PositionedStack> ingredients = recipe.getIngredientStacks( recipeIndex );
			if (gui instanceof GuiCraftingTerm || gui instanceof GuiPatternTerm)
			{
				PacketNEIRecipe packet = new PacketNEIRecipe(packIngredients(gui, ingredients, false));
				if (packet.size() >= 32*1024)
				{
					AELog.warn("Recipe for " + recipe.getRecipeName() + " has too many variants, reduced version will be used");
					packet = new PacketNEIRecipe(packIngredients(gui, ingredients, true));
				}
				NetworkHandler.instance.sendToServer(packet);
			}
		}
		catch( final Exception ignored )
		{
		}
		catch( final Error ignored )
		{
		}
	}

	// if the packet becomes too large, limit each slot contents to 3k
	private boolean testSize(final NBTTagCompound recipe) throws IOException
	{
		final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
		final DataOutputStream outputStream = new DataOutputStream( bytes );
		CompressedStreamTools.writeCompressed( recipe, outputStream );
		return bytes.size() > 3*1024;
	}

	private NBTTagCompound packIngredients(GuiContainer gui, List<PositionedStack> ingredients, boolean limited) throws IOException
	{
		final NBTTagCompound recipe = new NBTTagCompound();
		for( final PositionedStack positionedStack : ingredients )
		{
			final int col = ( positionedStack.relx - 25 ) / 18;
			final int row = ( positionedStack.rely - 6 ) / 18;
			if( positionedStack.items != null && positionedStack.items.length > 0 )
			{
				for( final Slot slot : (List<Slot>) gui.inventorySlots.inventorySlots )
				{
					if( slot instanceof SlotCraftingMatrix || slot instanceof SlotFakeCraftingMatrix)
					{
						if( slot.getSlotIndex() == col + row * 3 )
						{
							final NBTTagList tags = new NBTTagList();
							final List<ItemStack> list = new LinkedList<ItemStack>();

							// prefer pure crystals.
							for( int x = 0; x < positionedStack.items.length; x++ )
							{
								if( Platform.isRecipePrioritized( positionedStack.items[x] ) )
								{
									list.add( 0, positionedStack.items[x] );
								}
								else
								{
									list.add( positionedStack.items[x] );
								}
							}

							for( final ItemStack is : list )
							{
								final NBTTagCompound tag = new NBTTagCompound();
								is.writeToNBT( tag );
								tags.appendTag( tag );
								if (limited)
								{
									final NBTTagCompound test = new NBTTagCompound();
									test.setTag( "#" + slot.getSlotIndex(), tags );
									if (testSize(test))
										break;
								}
							}

							recipe.setTag( "#" + slot.getSlotIndex(), tags );
							break;
						}
					}
				}
			}
		}
		return recipe;
	}
}
