/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.config;

import appeng.api.config.AccessRestriction;
import appeng.api.config.ActionItems;
import appeng.api.config.CondenserOutput;
import appeng.api.config.CopyMode;
import appeng.api.config.FullnessMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.LevelEmitterMode;
import appeng.api.config.LevelType;
import appeng.api.config.OperationMode;
import appeng.api.config.PowerUnits;
import appeng.api.config.RedstoneMode;
import appeng.api.config.RelativeDirection;
import appeng.api.config.SchedulingMode;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.StorageFilter;
import appeng.api.config.TerminalStyle;
import appeng.api.config.ViewItems;
import appeng.api.config.YesNo;
import java.util.EnumSet;

public enum Settings {
    LEVEL_EMITTER_MODE(EnumSet.allOf(LevelEmitterMode.class)),
    REDSTONE_EMITTER(EnumSet.of(RedstoneMode.HIGH_SIGNAL, RedstoneMode.LOW_SIGNAL)),
    REDSTONE_CONTROLLED(EnumSet.allOf(RedstoneMode.class)),
    CONDENSER_OUTPUT(EnumSet.allOf(CondenserOutput.class)),
    POWER_UNITS(EnumSet.allOf(PowerUnits.class)),
    ACCESS(EnumSet.of(AccessRestriction.READ_WRITE, AccessRestriction.READ, AccessRestriction.WRITE)),
    SORT_DIRECTION(EnumSet.allOf(SortDir.class)),
    SORT_BY(EnumSet.allOf(SortOrder.class)),
    SEARCH_TOOLTIPS(EnumSet.of(YesNo.YES, YesNo.NO)),
    VIEW_MODE(EnumSet.allOf(ViewItems.class)),
    SEARCH_MODE(EnumSet.allOf(SearchBoxMode.class)),
    ACTIONS(EnumSet.allOf(ActionItems.class)),
    IO_DIRECTION(EnumSet.of(RelativeDirection.LEFT, RelativeDirection.RIGHT)),
    BLOCK(EnumSet.of(YesNo.YES, YesNo.NO)),
    OPERATION_MODE(EnumSet.allOf(OperationMode.class)),
    FULLNESS_MODE(EnumSet.allOf(FullnessMode.class)),
    CRAFT_ONLY(EnumSet.of(YesNo.YES, YesNo.NO)),
    FUZZY_MODE(EnumSet.allOf(FuzzyMode.class)),
    LEVEL_TYPE(EnumSet.allOf(LevelType.class)),
    TERMINAL_STYLE(EnumSet.of(TerminalStyle.TALL, TerminalStyle.SMALL)),
    COPY_MODE(EnumSet.allOf(CopyMode.class)),
    INTERFACE_TERMINAL(EnumSet.of(YesNo.YES, YesNo.NO)),
    CRAFT_VIA_REDSTONE(EnumSet.of(YesNo.YES, YesNo.NO)),
    STORAGE_FILTER(EnumSet.allOf(StorageFilter.class)),
    PLACE_BLOCK(EnumSet.of(YesNo.YES, YesNo.NO)),
    SCHEDULING_MODE(EnumSet.allOf(SchedulingMode.class)),
    SAVE_SEARCH(EnumSet.of(YesNo.YES, YesNo.NO));

    private final EnumSet<? extends Enum<?>> values;

    private Settings(EnumSet<? extends Enum<?>> possibleOptions) {
        if (possibleOptions.isEmpty()) {
            throw new IllegalArgumentException("Tried to instantiate an empty setting.");
        }
        this.values = possibleOptions;
    }

    public EnumSet<? extends Enum<?>> getPossibleValues() {
        return this.values;
    }
}

