/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.util.AEColor;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.hooks.TickHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;

public class PacketPaintedEntity
extends AppEngPacket {
    private final AEColor myColor;
    private final int entityId;
    private int ticks;

    public PacketPaintedEntity(ByteBuf stream) {
        this.entityId = stream.readInt();
        this.myColor = AEColor.values()[stream.readByte()];
        this.ticks = stream.readInt();
    }

    public PacketPaintedEntity(int myEntity, AEColor myColor, int ticksLeft) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        this.entityId = myEntity;
        data.writeInt(this.entityId);
        this.myColor = myColor;
        data.writeByte(this.myColor.ordinal());
        data.writeInt(ticksLeft);
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        TickHandler.PlayerColor pc = new TickHandler.PlayerColor(this.entityId, this.myColor, this.ticks);
        TickHandler.INSTANCE.getPlayerColors().put(this.entityId, pc);
    }
}

