/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.version;

import appeng.services.version.Channel;
import appeng.services.version.DefaultVersion;
import appeng.services.version.Version;
import appeng.services.version.exceptions.InvalidBuildException;
import appeng.services.version.exceptions.InvalidChannelException;
import appeng.services.version.exceptions.InvalidRevisionException;
import appeng.services.version.exceptions.InvalidVersionException;
import appeng.services.version.exceptions.MissingSeparatorException;
import appeng.services.version.exceptions.VersionCheckerException;
import com.google.common.base.Preconditions;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class VersionParser {
    private static final Pattern PATTERN_DOT = Pattern.compile("\\.");
    private static final Pattern PATTERN_DASH = Pattern.compile("-");
    private static final Pattern PATTERN_REVISION = Pattern.compile("[^0-9]+");
    private static final Pattern PATTERN_BUILD = Pattern.compile("[^0-9]+");
    private static final Pattern PATTERN_NATURAL = Pattern.compile("[0-9]+");
    private static final Pattern PATTERN_VALID_REVISION = Pattern.compile("^rv\\d+$");

    public Version parse(@Nonnull String raw) throws VersionCheckerException {
        Preconditions.checkNotNull((Object)raw);
        String transformed = this.transformDelimiter(raw);
        String[] split = transformed.split("_");
        return this.parseVersion(split);
    }

    private String transformDelimiter(@Nonnull String raw) throws MissingSeparatorException {
        if (!raw.contains(".") && !raw.contains("-")) {
            throw new MissingSeparatorException();
        }
        String withoutDot = PATTERN_DOT.matcher(raw).replaceAll("_");
        String withoutDash = PATTERN_DASH.matcher(withoutDot).replaceAll("_");
        return withoutDash;
    }

    private Version parseVersion(@Nonnull String[] splitRaw) throws InvalidVersionException, InvalidRevisionException, InvalidChannelException, InvalidBuildException {
        if (splitRaw.length != 3) {
            throw new InvalidVersionException();
        }
        String rawRevision = splitRaw[0];
        String rawChannel = splitRaw[1];
        String rawBuild = splitRaw[2];
        int revision = this.parseRevision(rawRevision);
        Channel channel = this.parseChannel(rawChannel);
        int build = this.parseBuild(rawBuild);
        return new DefaultVersion(revision, channel, build);
    }

    private int parseRevision(@Nonnull String rawRevision) throws InvalidRevisionException {
        if (!PATTERN_VALID_REVISION.matcher(rawRevision).matches()) {
            throw new InvalidRevisionException();
        }
        Scanner scanner = new Scanner(rawRevision);
        int revision = scanner.useDelimiter(PATTERN_REVISION).nextInt();
        scanner.close();
        return revision;
    }

    private Channel parseChannel(@Nonnull String rawChannel) throws InvalidChannelException {
        if (!(rawChannel.equalsIgnoreCase(Channel.Alpha.name()) || rawChannel.equalsIgnoreCase(Channel.Beta.name()) || rawChannel.equalsIgnoreCase(Channel.Stable.name()))) {
            throw new InvalidChannelException();
        }
        for (Channel channel : Channel.values()) {
            if (!channel.name().equalsIgnoreCase(rawChannel)) continue;
            return channel;
        }
        throw new InvalidChannelException();
    }

    private int parseBuild(@Nonnull String rawBuild) throws InvalidBuildException {
        if (!PATTERN_NATURAL.matcher(rawBuild).matches()) {
            throw new InvalidBuildException();
        }
        Scanner scanner = new Scanner(rawBuild);
        int build = scanner.useDelimiter(PATTERN_BUILD).nextInt();
        scanner.close();
        return build;
    }
}

