/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RecipeError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.ICraftHandler;
import appeng.api.recipes.IIngredient;
import appeng.core.AELog;
import appeng.recipes.RecipeHandler;
import appeng.recipes.handlers.IWebsiteSerializer;
import appeng.util.Platform;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class HCCrusher
implements ICraftHandler,
IWebsiteSerializer {
    private IIngredient pro_input;
    private IIngredient[] pro_output;

    @Override
    public void setup(List<List<IIngredient>> input, List<List<IIngredient>> output) throws RecipeError {
        if (input.size() == 1 && output.size() == 1) {
            int outs = output.get(0).size();
            if (input.get(0).size() == 1 && outs == 1) {
                this.pro_input = input.get(0).get(0);
                this.pro_output = output.get(0).toArray(new IIngredient[outs]);
                return;
            }
        }
        throw new RecipeError("Crusher must have a single input, and single output.");
    }

    @Override
    public void register() throws RegistrationError, MissingIngredientError {
        for (ItemStack beginStack : this.pro_input.getItemStackSet()) {
            try {
                NBTTagCompound toRegister = new NBTTagCompound();
                ItemStack endStack = this.pro_output[0].getItemStack();
                NBTTagCompound itemFrom = new NBTTagCompound();
                NBTTagCompound itemTo = new NBTTagCompound();
                beginStack.func_77955_b(itemFrom);
                endStack.func_77955_b(itemTo);
                toRegister.func_74782_a("itemFrom", (NBTBase)itemFrom);
                toRegister.func_74782_a("itemTo", (NBTBase)itemTo);
                toRegister.func_74776_a("pressureRatio", 1.0f);
                FMLInterModComms.sendMessage((String)"HydCraft", (String)"registerCrushingRecipe", (NBTTagCompound)toRegister);
            }
            catch (RuntimeException err) {
                AELog.info("Hydraulicraft not happy - " + err.getMessage(), new Object[0]);
            }
        }
    }

    @Override
    public String getPattern(RecipeHandler h) {
        return null;
    }

    @Override
    public boolean canCraft(ItemStack output) throws RegistrationError, MissingIngredientError {
        return Platform.isSameItemPrecise(this.pro_output[0].getItemStack(), output);
    }
}

