/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.classic;

import com.github.bartimaeusnek.bartworks.API.ITileAddsInformation;
import com.github.bartimaeusnek.bartworks.API.ITileDropsContent;
import com.github.bartimaeusnek.bartworks.API.ITileHasDifferentTextureSides;
import com.github.bartimaeusnek.bartworks.API.ITileWithGUI;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Pollution;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.StatCollector;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class BW_TileEntity_HeatedWaterPump
extends TileEntity
implements ITileDropsContent,
IFluidHandler,
IFluidTank,
ITileWithGUI,
ITileAddsInformation,
ITileHasDifferentTextureSides {
    public static final int FUELSLOT = 0;
    public static final Fluid WATER = FluidRegistry.WATER;
    public ItemStack fuelstack;
    public FluidStack outputstack = new FluidStack(FluidRegistry.WATER, 0);
    public int fuel;
    public byte tick;
    public int maxfuel;
    public ItemStack fakestack = new ItemStack(Blocks.field_150355_j);

    public void func_145841_b(NBTTagCompound p_145841_1_) {
        NBTTagCompound subItemStack = new NBTTagCompound();
        if (this.fuelstack != null) {
            this.fuelstack.func_77955_b(subItemStack);
        }
        p_145841_1_.func_74782_a("ItemStack", (NBTBase)subItemStack);
        NBTTagCompound subFluidStack = new NBTTagCompound();
        this.outputstack.writeToNBT(subFluidStack);
        p_145841_1_.func_74782_a("FluidStack", (NBTBase)subFluidStack);
        p_145841_1_.func_74768_a("fuel", this.fuel);
        p_145841_1_.func_74768_a("maxfuel", this.maxfuel);
        p_145841_1_.func_74774_a("tick", this.tick);
        super.func_145841_b(p_145841_1_);
    }

    public void func_145839_a(NBTTagCompound p_145839_1_) {
        this.tick = p_145839_1_.func_74771_c("tick");
        this.fuel = p_145839_1_.func_74762_e("fuel");
        this.maxfuel = p_145839_1_.func_74762_e("maxfuel");
        this.outputstack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)p_145839_1_.func_74775_l("FluidStack"));
        if (!p_145839_1_.func_74775_l("ItemStack").equals((Object)new NBTTagCompound())) {
            this.fuelstack = ItemStack.func_77949_a((NBTTagCompound)p_145839_1_.func_74775_l("ItemStack"));
        }
        super.func_145839_a(p_145839_1_);
    }

    private boolean checkPreUpdate() {
        return this.field_145850_b.field_72995_K || (this.fuelstack == null || this.fuelstack.field_77994_a <= 0) && this.fuel <= 0 || this.tick == 0 && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == Blocks.field_150350_a;
    }

    private void fixUnderlflow() {
        if (this.fuel < 0) {
            this.fuel = 0;
        }
    }

    private void handleRefuel() {
        if (this.fuelstack != null && this.fuel == 0) {
            this.fuel = this.maxfuel = TileEntityFurnace.func_145952_a((ItemStack)this.fuelstack);
            --this.fuelstack.field_77994_a;
            if (this.fuelstack.field_77994_a <= 0) {
                this.fuelstack = null;
            }
        }
    }

    private void handleWaterGeneration() {
        if (this.fuel > 0) {
            this.tick = (byte)(this.tick + 1);
            --this.fuel;
            if (this.tick % 20 == 0) {
                if (this.outputstack.amount <= 8000 - ConfigHandler.mbWaterperSec) {
                    this.outputstack.amount += ConfigHandler.mbWaterperSec;
                }
                this.tick = 0;
            }
        }
    }

    public void func_145845_h() {
        this.pushWaterToAdjacentTiles();
        if (this.checkPreUpdate()) {
            return;
        }
        this.fixUnderlflow();
        this.handleRefuel();
        this.handleWaterGeneration();
        this.causePollution();
    }

    private void pushWaterToAdjacentTiles() {
        Arrays.stream(ForgeDirection.values(), 0, 6).forEach(direction -> Optional.ofNullable(this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ)).ifPresent(te -> {
            IFluidTank tank;
            int drainage;
            if (te instanceof IFluidHandler) {
                int drainage2;
                IFluidHandler tank2 = (IFluidHandler)te;
                if (tank2.canFill(direction.getOpposite(), this.outputstack.getFluid()) && (drainage2 = tank2.fill(direction.getOpposite(), this.outputstack, false)) > 0) {
                    tank2.fill(direction.getOpposite(), this.outputstack, true);
                    this.drain(drainage2, true);
                }
            } else if (te instanceof IFluidTank && (drainage = (tank = (IFluidTank)te).fill(this.outputstack, false)) > 0) {
                tank.fill(this.outputstack, true);
                this.drain(drainage, true);
            }
        }));
    }

    private void causePollution() {
        Optional.ofNullable(this.field_145850_b).ifPresent(e -> {
            if (e.func_82737_E() % 20L == 0L) {
                Optional.ofNullable(e.func_72938_d(this.field_145851_c, this.field_145849_e)).ifPresent(c -> GT_Pollution.addPollution((Chunk)c, (int)5));
            }
        });
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return TileEntityFurnace.func_145952_a((ItemStack)p_102007_2_) > 0;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        if (p_70301_1_ == 0) {
            return this.fuelstack;
        }
        return this.fakestack;
    }

    public ItemStack func_70298_a(int slot, int ammount) {
        if (slot != 0 || this.fuelstack == null || ammount > this.fuelstack.field_77994_a) {
            return null;
        }
        return this.fuelstack.func_77979_a(ammount);
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack p_70299_2_) {
        if (slot == 0) {
            this.fuelstack = p_70299_2_;
        } else {
            this.fakestack = p_70299_2_;
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return TileEntityFurnace.func_145952_a((ItemStack)p_94041_2_) > 0 && p_94041_1_ == 0;
    }

    public FluidStack getFluid() {
        return this.outputstack.amount > 0 ? this.outputstack : null;
    }

    public int getFluidAmount() {
        return this.outputstack.amount;
    }

    public int getCapacity() {
        return 8000;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        int actualdrain = maxDrain;
        if (actualdrain > this.outputstack.amount) {
            actualdrain = this.outputstack.amount;
        }
        FluidStack ret = new FluidStack(WATER, actualdrain);
        if (ret.amount == 0) {
            ret = null;
        }
        if (doDrain) {
            this.outputstack.amount -= actualdrain;
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.outputstack, this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this, actualdrain));
        }
        return ret;
    }

    @Override
    public int getGUIID() {
        return 3;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == WATER && this.drain(resource.amount, false) != null) {
            return this.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == null || fluid == WATER;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getInfo()};
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"tooltip.tile.waterpump.0.name") + " " + GT_Utility.formatNumbers((long)ConfigHandler.mbWaterperSec) + StatCollector.func_74838_a((String)"tooltip.tile.waterpump.1.name"), StatCollector.func_74838_a((String)"tooltip.tile.waterpump.2.name")};
    }

    @Override
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        ITileHasDifferentTextureSides.texture[ForgeDirection.UP.ordinal()] = par1IconRegister.func_94245_a("bartworks:heatedWaterPumpTop");
        ITileHasDifferentTextureSides.texture[ForgeDirection.DOWN.ordinal()] = par1IconRegister.func_94245_a("bartworks:heatedWaterPumpDown");
        for (int i = 2; i < 7; ++i) {
            ITileHasDifferentTextureSides.texture[i] = par1IconRegister.func_94245_a("bartworks:heatedWaterPumpSide");
        }
    }
}

