/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.api.crafting;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.mcft.copy.betterstorage.api.BetterStorageUtils;
import net.mcft.copy.betterstorage.api.crafting.RecipeInputBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RecipeInputItemStack
extends RecipeInputBase {
    public final ItemStack stack;
    private List<ItemStack> list = null;

    public RecipeInputItemStack(ItemStack stack) {
        this.stack = stack;
    }

    public RecipeInputItemStack(ItemStack stack, boolean nbtSensitive) {
        this(stack);
        if (nbtSensitive) {
            if (!stack.hasTagCompound()) {
                stack.setTagCompound(new NBTTagCompound());
            }
        } else if (stack.hasTagCompound()) {
            stack.setTagCompound(null);
        }
    }

    @Override
    public int getAmount() {
        return this.stack.stackSize;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return BetterStorageUtils.wildcardMatch(this.stack, stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getPossibleMatches() {
        ItemStack stack = this.stack.copy();
        if (stack.getItemDamage() == Short.MAX_VALUE) {
            stack.setItemDamage(0);
        }
        return Arrays.asList(stack);
    }
}

