/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.addon.thaumcraft;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import java.util.List;
import net.mcft.copy.betterstorage.addon.thaumcraft.ThaumcraftAddon;
import net.mcft.copy.betterstorage.addon.thaumcraft.ThaumcraftResources;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.tile.TileBackpack;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import thaumcraft.api.IRepairable;
import thaumcraft.api.IVisDiscountGear;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;

public class ItemThaumcraftBackpack
extends ItemBackpack
implements IRepairable,
IVisDiscountGear {
    private static Method doRepairMethod = null;

    public ItemThaumcraftBackpack() {
        super(ItemBackpack.material);
        this.setMaxDamage(288);
    }

    @Override
    public String getBackpackName() {
        return "container.betterstorage.thaumcraftBackpack";
    }

    @Override
    public TileBackpack getBlockType() {
        return ThaumcraftAddon.thaumcraftBackpack;
    }

    @Override
    public int getBackpackColumns() {
        return 13;
    }

    @Override
    protected int getDefaultColor() {
        return 7089320;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return (type == "overlay" ? ThaumcraftResources.thaumcraftBackpackTextureOverlay : ThaumcraftResources.thaumcraftBackpackTexture).toString();
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        super.addInformation(stack, player, list, advancedTooltips);
        list.add(String.format("%s%s: %s%%", EnumChatFormatting.DARK_PURPLE, StatCollector.translateToLocal((String)"tc.visdiscount"), 2));
    }

    public int getItemEnchantability() {
        return 25;
    }

    public boolean getIsRepairable(ItemStack stack, ItemStack repairMaterial) {
        return StackUtils.matches(stack, ThaumcraftAddon.fabric, false);
    }

    @Override
    public void onEquippedUpdate(EntityLivingBase entity, ItemStack backpack) {
        super.onEquippedUpdate(entity, backpack);
        if (!entity.worldObj.isRemote && entity instanceof EntityPlayer) {
            this.repairItems(backpack, (EntityPlayer)entity);
        }
    }

    public void repairItems(ItemStack backpack, EntityPlayer player) {
        IInventory backpackInventory = ItemBackpack.getBackpackItems((EntityLivingBase)player);
        int repair = EnchantmentHelper.getEnchantmentLevel((int)ThaumcraftApi.enchantRepair, (ItemStack)backpack);
        int time = (repair > 0 ? 15 - Math.min(repair, 2) * 5 : 30) * 20;
        if (player.ticksExisted % time > 0) {
            return;
        }
        for (int i = 0; i < backpackInventory.getSizeInventory(); ++i) {
            ItemStack stack = backpackInventory.getStackInSlot(i);
            if (stack == null || !stack.isItemDamaged() || !(stack.getItem() instanceof IRepairable) || EnchantmentHelper.getEnchantmentLevel((int)ThaumcraftApi.enchantRepair, (ItemStack)stack) <= 0) continue;
            ItemThaumcraftBackpack.repairItem(stack, player);
        }
    }

    private static void repairItem(ItemStack stack, EntityPlayer player) {
        if (doRepairMethod == null) {
            try {
                Class<?> clazz = Class.forName("thaumcraft.common.lib.events.EventHandlerEntity");
                doRepairMethod = clazz.getMethod("doRepair", ItemStack.class, EntityPlayer.class);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        try {
            doRepairMethod.invoke(null, stack, player);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getVisDiscount(ItemStack stack, EntityPlayer player, Aspect aspect) {
        return 2;
    }
}

