/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.attachment;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.api.BetterStorageEnchantment;
import net.mcft.copy.betterstorage.api.lock.EnumLockInteraction;
import net.mcft.copy.betterstorage.api.lock.IKey;
import net.mcft.copy.betterstorage.api.lock.ILock;
import net.mcft.copy.betterstorage.api.lock.ILockable;
import net.mcft.copy.betterstorage.attachment.EnumAttachmentInteraction;
import net.mcft.copy.betterstorage.attachment.IAttachmentRenderer;
import net.mcft.copy.betterstorage.attachment.ItemAttachment;
import net.mcft.copy.betterstorage.attachment.LockAttachmentRenderer;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.item.ItemBetterStorage;
import net.mcft.copy.betterstorage.network.packet.PacketLockHit;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class LockAttachment
extends ItemAttachment {
    public int hit = 0;
    public int breakProgress = 0;
    public float wiggle = 0.0f;
    public float wiggleStrength = 0.0f;

    public LockAttachment(TileEntity tileEntity, int subId) {
        super(tileEntity, subId);
        if (!(tileEntity instanceof ILockable)) {
            throw new IllegalArgumentException("tileEntity must be ILockable.");
        }
    }

    @Override
    public boolean boxVisible(EntityPlayer player) {
        ItemStack holding = player != null ? player.getCurrentEquippedItem() : null;
        return this.item != null || StackUtils.isLock(holding);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IAttachmentRenderer getRenderer() {
        return LockAttachmentRenderer.instance;
    }

    @Override
    public void update() {
        this.hit = Math.max(-20, this.hit - 1);
        if (this.hit <= -20) {
            this.breakProgress = Math.max(0, this.breakProgress - 1);
        }
        if (this.tileEntity.getWorldObj().isRemote) {
            this.wiggle += 1.0f;
            this.wiggleStrength = Math.max(0.0f, this.wiggleStrength * 0.9f - 0.1f);
        }
    }

    @Override
    public boolean interact(EntityPlayer player, EnumAttachmentInteraction type) {
        ItemStack holding = player.getCurrentEquippedItem();
        return type == EnumAttachmentInteraction.attack ? this.attack(player, holding) : this.use(player, holding);
    }

    @Override
    public ItemStack pick() {
        int fullColor;
        if (this.item == null) {
            return null;
        }
        ItemStack key = new ItemStack((Item)BetterStorageItems.key);
        ItemBetterStorage.setID(key, ItemBetterStorage.getID(this.item));
        int color = ItemBetterStorage.getColor(this.item);
        if (color >= 0) {
            ItemBetterStorage.setColor(key, color);
        }
        if ((fullColor = ItemBetterStorage.getFullColor(this.item)) >= 0) {
            ItemBetterStorage.setFullColor(key, fullColor);
        }
        return key;
    }

    private boolean attack(EntityPlayer player, ItemStack holding) {
        boolean canHurt;
        ILockable lockable = (ILockable)this.tileEntity;
        ItemStack lock = lockable.getLock();
        if (lock == null) {
            return false;
        }
        boolean bl = canHurt = this.hit <= 0 && this.canHurtLock(holding);
        if (canHurt) {
            holding.damageItem(2, (EntityLivingBase)player);
            if (holding.stackSize <= 0) {
                player.destroyCurrentEquippedItem();
            }
        }
        if (!player.worldObj.isRemote) {
            if (canHurt) {
                this.hit = 10;
                int damage = (int)((AttributeModifier)holding.getAttributeModifiers().get((Object)SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName()).iterator().next()).getAmount();
                int sharpness = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.sharpness.effectId, (ItemStack)holding);
                int efficiency = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.efficiency.effectId, (ItemStack)holding);
                this.breakProgress += Math.min(damage, 10) / 2 + Math.min(Math.max(sharpness, efficiency), 5);
                int persistance = BetterStorageEnchantment.getLevel(lock, "persistance");
                if (this.breakProgress > 100 * (1 + persistance)) {
                    int unbreaking = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.unbreaking.effectId, (ItemStack)lock);
                    lock.setItemDamage(lock.getItemDamage() + 10 / (1 + unbreaking));
                    if (lock.getItemDamage() < lock.getMaxDamage()) {
                        AxisAlignedBB box = this.getHighlightBox();
                        double x = (box.minX + box.maxX) / 2.0;
                        double y = (box.minY + box.maxY) / 2.0;
                        double z = (box.minZ + box.maxZ) / 2.0;
                        EntityItem entityItem = WorldUtils.spawnItem(this.tileEntity.getWorldObj(), x, y, z, lock);
                    }
                    lockable.setLock(null);
                    this.breakProgress = 0;
                }
                ((ILock)lock.getItem()).applyEffects(lock, lockable, player, EnumLockInteraction.ATTACK);
            }
            BetterStorage.networkChannel.sendToAllAround(new PacketLockHit(this.tileEntity.xCoord, this.tileEntity.yCoord, this.tileEntity.zCoord, canHurt), this.tileEntity.getWorldObj(), this.tileEntity.xCoord, this.tileEntity.yCoord, this.tileEntity.zCoord, 32.0);
        } else {
            this.hit(canHurt);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void hit(boolean damage) {
        this.wiggleStrength = Math.min(20.0f, this.wiggleStrength + 12.0f);
        if (damage) {
            this.hit = 10;
            AxisAlignedBB box = this.getHighlightBox();
            double x = (box.minX + box.maxX) / 2.0;
            double y = (box.minY + box.maxY) / 2.0;
            double z = (box.minZ + box.maxZ) / 2.0;
            this.tileEntity.getWorldObj().playSound(x, y, z, "random.break", 0.5f, 2.5f, false);
        }
    }

    private boolean use(EntityPlayer player, ItemStack holding) {
        if (player.worldObj.isRemote) {
            return false;
        }
        ILockable lockable = (ILockable)this.tileEntity;
        ItemStack lock = lockable.getLock();
        if (lock == null) {
            if (StackUtils.isLock(holding) && lockable.isLockValid(holding)) {
                lockable.setLock(holding);
                player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                return true;
            }
        } else if (StackUtils.isKey(holding)) {
            IKey keyType = (IKey)holding.getItem();
            ILock lockType = (ILock)lock.getItem();
            boolean success = keyType.unlock(holding, lock, true);
            lockType.onUnlock(lock, holding, lockable, player, success);
            if (!success) {
                return true;
            }
            if (player.isSneaking()) {
                AxisAlignedBB box = this.getHighlightBox();
                double x = (box.minX + box.maxX) / 2.0;
                double y = (box.minY + box.maxY) / 2.0;
                double z = (box.minZ + box.maxZ) / 2.0;
                EntityItem item = WorldUtils.spawnItem(player.worldObj, x, y, z, lock);
                lockable.setLock(null);
            } else {
                lockable.useUnlocked(player);
            }
            return true;
        }
        return false;
    }

    private boolean canHurtLock(ItemStack stack) {
        if (stack == null || !BetterStorage.globalConfig.getBoolean("general.lockBreakable")) {
            return false;
        }
        Item item = stack.getItem();
        return item instanceof ItemSword || item instanceof ItemPickaxe || item instanceof ItemAxe;
    }
}

