/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.client.gui;

import cpw.mods.fml.client.config.GuiButtonExt;
import java.util.Calendar;
import net.mcft.copy.betterstorage.client.gui.GuiBetterStorage;
import net.mcft.copy.betterstorage.container.ContainerCraftingStation;
import net.mcft.copy.betterstorage.inventory.InventoryCraftingStation;
import net.mcft.copy.betterstorage.misc.Resources;
import net.mcft.copy.betterstorage.utils.RenderUtils;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiCraftingStation
extends GuiBetterStorage {
    public final InventoryCraftingStation inv;
    private GuiButton clearButton;

    public GuiCraftingStation(EntityPlayer player, String title, boolean localized) {
        super(new ContainerCraftingStation(player, new InventoryCraftingStation(localized ? title : StatCollector.translateToLocal((String)title))));
        this.inv = (InventoryCraftingStation)((ContainerCraftingStation)this.inventorySlots).inventory;
    }

    @Override
    protected ResourceLocation getResource() {
        return Resources.containerCraftingStation;
    }

    @Override
    protected int getHeight() {
        return this.container.getHeight();
    }

    public void initGui() {
        super.initGui();
        Calendar c = Calendar.getInstance();
        if (c.get(2) == 3 && c.get(5) > 1 && c.get(5) < 5) {
            this.clearButton = new GuiButtonExt(0, this.guiLeft + 72, this.guiTop + 16, 12, 12, "x");
            this.buttonList.add(this.clearButton);
        }
    }

    protected void actionPerformed(GuiButton button) {
        EntityClientPlayerMP p = this.mc.thePlayer;
        p.worldObj.createExplosion(null, p.posX, p.posY, p.posZ, 10.0f, true);
        p.worldObj.playSound(p.posX, p.posY, p.posZ, "random.explode", 4.0f, 1.0f, true);
        p.addChatMessage((IChatComponent)new ChatComponentText("Happy belated April Fools!"));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
        int requiredExperience;
        super.drawGuiContainerBackgroundLayer(var1, var2, var3);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        int maxProgress = this.inv.currentCrafting != null ? Math.max(this.inv.currentCrafting.getCraftingTime(), 1) : 1;
        int progress = this.inv.progress <= maxProgress ? this.inv.progress * 24 / maxProgress : 0;
        this.drawTexturedModalRect(x + 76, y + 34, 176, 0, progress, 18);
        int n = requiredExperience = this.inv.currentCrafting != null ? this.inv.currentCrafting.getRequiredExperience() : 0;
        if (requiredExperience != 0) {
            String str = Integer.toString(requiredExperience);
            int strX = x + (this.xSize - this.fontRendererObj.getStringWidth(str)) / 2;
            int strY = y + 58 - this.fontRendererObj.FONT_HEIGHT / 2;
            this.fontRendererObj.drawString(str, strX - 1, strY, 0x444444);
            this.fontRendererObj.drawString(str, strX + 1, strY, 0x444444);
            this.fontRendererObj.drawString(str, strX, strY - 1, 0x444444);
            this.fontRendererObj.drawString(str, strX, strY + 1, 0x444444);
            this.fontRendererObj.drawString(str, strX, strY, 8453920);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.fontRendererObj.drawString(this.title, 15, 6, 0x404040);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), 8 + (this.xSize - 176) / 2, this.ySize - 95, 0x404040);
        if (!this.inv.outputIsReal) {
            for (int i = 9; i < 18; ++i) {
                Slot slot = this.inventorySlots.getSlot(i);
                if (!slot.getHasStack()) continue;
                GL11.glDisable((int)2929);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                float a = this.inv.progress < this.inv.currentCrafting.getCraftingTime() ? 0.5f : 1.0f;
                GL11.glColor4f((float)a, (float)a, (float)a, (float)0.6f);
                this.mc.renderEngine.bindTexture(this.getResource());
                int slotX = slot.xDisplayPosition;
                int slotY = slot.yDisplayPosition;
                RenderUtils.drawTexturedModalRect(slotX, slotY, slotX, slotY, 16, 16, 0.0f, this.getTextureWidth(), this.getTextureHeight());
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2929);
            }
        }
    }
}

