/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.config.setting;

import cpw.mods.fml.client.config.ConfigGuiType;
import net.mcft.copy.betterstorage.config.Config;
import net.mcft.copy.betterstorage.config.setting.SinglePropertySetting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class BooleanSetting
extends SinglePropertySetting<Boolean> {
    public BooleanSetting(Config config, String fullName, Boolean defaultValue) {
        super(config, fullName, defaultValue, ConfigGuiType.BOOLEAN);
    }

    public BooleanSetting(Config config, String fullName, Boolean defaultValue, String langKey) {
        super(config, fullName, defaultValue, ConfigGuiType.BOOLEAN, langKey);
    }

    public BooleanSetting(Config config, String fullName) {
        this(config, fullName, false);
    }

    public BooleanSetting(Config config, String fullName, String langKey) {
        this(config, fullName, false, langKey);
    }

    public BooleanSetting setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    public BooleanSetting setSynced() {
        super.setSynced();
        return this;
    }

    @Override
    protected Property.Type getPropertyType() {
        return Property.Type.BOOLEAN;
    }

    @Override
    protected Boolean loadInternal(Configuration config) {
        return this.getProperty(config).getBoolean(((Boolean)this.defaultValue).booleanValue());
    }

    @Override
    protected void saveInternal(Configuration config, Boolean value) {
        this.getProperty(config).set(value.booleanValue());
    }

    @Override
    protected Boolean readInternal(NBTTagCompound compound) {
        return compound.getBoolean(this.fullName);
    }

    @Override
    protected void writeInternal(NBTTagCompound compound, Boolean value) {
        compound.setBoolean(this.fullName, value.booleanValue());
    }
}

