/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.container;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import invtweaks.api.container.InventoryContainer;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryCratePlayerView;
import net.mcft.copy.betterstorage.tile.crate.CratePileData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2FPacketSetSlot;

@InventoryContainer
public class ContainerCrate
extends ContainerBetterStorage {
    private InventoryCratePlayerView playerView;
    public int fullness = 0;
    private int lastFullness = 0;

    public ContainerCrate(EntityPlayer player, InventoryCratePlayerView inventory) {
        super(player, inventory, 9, inventory.getSizeInventory() / 9);
        this.playerView = inventory;
        CratePileData data = inventory.data;
        this.fullness = data.getOccupiedSlots() * 255 / data.getCapacity();
    }

    public ContainerCrate(EntityPlayer player, int rows, String name, boolean localized) {
        super(player, (IInventory)new InventoryBasic(name, !localized, 9 * rows), 9, rows);
    }

    public void detectAndSendChanges() {
        if (this.playerView == null) {
            return;
        }
        super.detectAndSendChanges();
        CratePileData data = this.playerView.data;
        if (data.getNumCrates() <= 0) {
            return;
        }
        this.fullness = data.getOccupiedSlots() * 255 / data.getCapacity();
        this.sendUpdateIfChanged(0, this.fullness, this.lastFullness);
        this.lastFullness = this.fullness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int val) {
        if (id == 0) {
            this.fullness = val;
        }
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, int slotId) {
        if (this.playerView == null) {
            return super.transferStackInSlot(player, slotId);
        }
        Slot slot = (Slot)this.inventorySlots.get(slotId);
        ItemStack slotStack = slot.getStack();
        if (slotStack == null) {
            return null;
        }
        ItemStack stackBefore = slotStack.copy();
        if (slotId < this.getColumns() * this.getRows()) {
            int count = slotStack.stackSize;
            boolean success = this.mergeItemStack(slotStack, this.playerView.getSizeInventory(), this.inventorySlots.size(), true);
            int amount = count - slotStack.stackSize;
            slotStack.stackSize = count;
            this.playerView.decrStackSize(slotId, amount);
            if (!success) {
                return null;
            }
        } else {
            boolean success = this.playerView.canFitSome(slotStack);
            ItemStack overflow = this.playerView.data.addItems(slotStack);
            slot.putStack(overflow);
            ((EntityPlayerMP)player).playerNetServerHandler.sendPacket((Packet)new S2FPacketSetSlot(player.openContainer.windowId, slotId, overflow));
            if (!success) {
                return null;
            }
        }
        return stackBefore;
    }
}

