/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.entity;

import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityCluckington
extends EntityChicken {
    private int healTimer = 0;

    public EntityCluckington(World world) {
        super(world);
        this.setSize(0.6f, 0.8f);
        EntityAITasks.EntityAITaskEntry panic = (EntityAITasks.EntityAITaskEntry)this.tasks.taskEntries.get(1);
        EntityAITasks.EntityAITaskEntry mate = (EntityAITasks.EntityAITaskEntry)this.tasks.taskEntries.get(2);
        EntityAITasks.EntityAITaskEntry tempt = (EntityAITasks.EntityAITaskEntry)this.tasks.taskEntries.get(3);
        EntityAITasks.EntityAITaskEntry follow = (EntityAITasks.EntityAITaskEntry)this.tasks.taskEntries.get(4);
        this.tasks.removeTask(panic.action);
        this.tasks.removeTask(mate.action);
        this.tasks.removeTask(tempt.action);
        this.tasks.removeTask(follow.action);
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityZombie.class, 1.0, false));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, 0, true));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.35);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(2.0);
    }

    public boolean hasCustomNameTag() {
        return true;
    }

    public String getCustomNameTag() {
        return "Cluckington";
    }

    public boolean isBreedingItem(ItemStack stack) {
        return stack.getItem() == Items.skull && "wyld".equalsIgnoreCase(StackUtils.get(stack, "", "SkullOwner"));
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (++this.healTimer > 40) {
            this.healTimer = 0;
            this.heal(1.0f);
        }
    }

    public boolean attackEntityAsMob(Entity target) {
        return target.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getBaseValue());
    }

    public static void spawn(EntityChicken target) {
        target.setHealth(0.0f);
        target.setDead();
        EntityCluckington cluck = new EntityCluckington(target.worldObj);
        cluck.setPositionAndRotation(target.posX, target.posY, target.posZ, target.rotationYaw, target.rotationPitch);
        cluck.worldObj.spawnEntityInWorld((Entity)cluck);
        cluck.worldObj.createExplosion((Entity)cluck, cluck.posX, cluck.posY, cluck.posZ, 1.0f, true);
    }
}

