/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.inventory;

import net.mcft.copy.betterstorage.inventory.InventoryStacks;
import net.mcft.copy.betterstorage.inventory.InventoryWrapper;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.utils.DirectionUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class InventoryBackpackEquipped
extends InventoryWrapper {
    public final EntityLivingBase carrier;
    public final EntityPlayer player;

    public InventoryBackpackEquipped(EntityLivingBase carrier, EntityPlayer player, IInventory inventory) {
        super(inventory);
        this.carrier = carrier;
        this.player = player;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        boolean carriesBackpack = this.base.equals(ItemBackpack.getBackpackItems(this.carrier, player));
        double distance = player.getDistanceToEntity((Entity)this.carrier);
        double direction = DirectionUtils.angleDifference(this.carrier.renderYawOffset + 90.0f, DirectionUtils.angleBetween((Entity)this.carrier, (Entity)player));
        return this.carrier.isEntityAlive() && carriesBackpack && distance < 2.0 && Math.abs(direction) > 135.0 || this.carrier == player;
    }

    @Override
    public void markDirty() {
        if (!(this.base instanceof InventoryStacks)) {
            return;
        }
        ItemBackpack.updateHasItems(this.carrier, ItemBackpack.getBackpackData(this.carrier));
    }

    @Override
    public void openInventory() {
        ++ItemBackpack.getBackpackData((EntityLivingBase)this.carrier).playersUsing;
    }

    @Override
    public void closeInventory() {
        --ItemBackpack.getBackpackData((EntityLivingBase)this.carrier).playersUsing;
    }
}

