/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.inventory;

import java.util.List;
import net.mcft.copy.betterstorage.api.crate.ICrateWatcher;
import net.mcft.copy.betterstorage.config.GlobalConfig;
import net.mcft.copy.betterstorage.inventory.InventoryBetterStorage;
import net.mcft.copy.betterstorage.misc.ItemIdentifier;
import net.mcft.copy.betterstorage.tile.crate.CratePileData;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class InventoryCrateBlockView
extends InventoryBetterStorage
implements ICrateWatcher {
    private static final int numStacksStored = 4;
    private final CratePileData data;
    private final ItemStack[] originalStacks = new ItemStack[4];
    private final ItemStack[] exposedStacks = new ItemStack[4];
    private boolean changed = true;
    private boolean isModifying = false;
    private boolean accessed = false;

    public InventoryCrateBlockView(CratePileData data) {
        super("container.betterstorage.crate");
        this.data = data;
        data.addWatcher(this);
    }

    public int getSizeInventory() {
        return 5;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return slot > 0 || this.data.getSpaceForItem(stack) >= stack.stackSize;
    }

    public ItemStack getStackInSlot(int slot) {
        this.access();
        if (slot <= 0 || slot >= this.getSizeInventory()) {
            return null;
        }
        return this.exposedStacks[slot - 1];
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.access();
        if (slot < 0 || slot >= this.getSizeInventory()) {
            return;
        }
        ItemStack oldStack = null;
        if (slot > 0) {
            oldStack = this.originalStacks[slot - 1];
            this.exposedStacks[slot - 1] = stack;
            this.originalStacks[slot - 1] = ItemStack.copyItemStack((ItemStack)stack);
        }
        this.isModifying = true;
        if (oldStack != null) {
            if (StackUtils.matches(oldStack, stack)) {
                int count = stack.stackSize - oldStack.stackSize;
                if (count > 0) {
                    this.data.addItems(StackUtils.copyStack(stack, count));
                } else if (count < 0) {
                    this.data.removeItems(StackUtils.copyStack(stack, -count));
                }
                this.isModifying = false;
                return;
            }
            this.data.removeItems(oldStack);
        }
        this.data.addItems(stack);
        this.isModifying = false;
    }

    @Override
    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack == null) {
            return null;
        }
        if (stack.stackSize <= (amount = Math.min(amount, stack.stackSize))) {
            this.exposedStacks[slot - 1] = null;
            this.originalStacks[slot - 1] = null;
        } else {
            this.originalStacks[slot - 1].stackSize = this.exposedStacks[slot - 1].stackSize -= amount;
        }
        this.isModifying = true;
        ItemStack result = this.data.removeItems(new ItemIdentifier(stack), amount);
        this.isModifying = false;
        return result;
    }

    public void markDirty() {
        for (int i = 0; i < 4; ++i) {
            if (ItemStack.areItemStacksEqual((ItemStack)this.originalStacks[i], (ItemStack)this.exposedStacks[i])) continue;
            this.setInventorySlotContents(i + 1, this.exposedStacks[i]);
        }
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public void onUpdate() {
        if (!((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue() || !this.accessed) {
            return;
        }
        this.accessed = false;
        this.changed = true;
    }

    private void access() {
        this.accessed = true;
        if (this.changed) {
            List<ItemStack> picked = this.data.getContents().getRandomStacks(4);
            for (int i = 0; i < 4; ++i) {
                this.exposedStacks[i] = i < picked.size() ? picked.get(i) : null;
                this.originalStacks[i] = ItemStack.copyItemStack((ItemStack)this.exposedStacks[i]);
            }
            this.changed = false;
        }
    }

    @Override
    public void onCrateItemsModified(ItemStack stack) {
        if (!this.isModifying) {
            this.changed = true;
        }
    }
}

