/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.inventory;

import net.mcft.copy.betterstorage.inventory.InventoryStacks;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class InventoryItem
extends InventoryStacks {
    private final String title;
    protected final EntityPlayer player;
    protected final int slot;
    protected final ItemStack stack;

    public InventoryItem(EntityPlayer player, int size, String title, boolean localized) {
        super(new ItemStack[][]{StackUtils.getStackContents(player.getCurrentEquippedItem(), size)});
        this.title = title;
        this.player = player;
        this.slot = player.inventory.currentItem;
        this.stack = player.getCurrentEquippedItem().copy();
    }

    @Override
    public String getInventoryName() {
        return this.title;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        return true;
    }

    @Override
    public void closeInventory() {
        this.updateStack();
    }

    protected void updateStack() {
        StackUtils.setStackContents(this.stack, this.allContents[0]);
        this.player.inventory.setInventorySlotContents(this.slot, this.stack);
    }
}

