/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.inventory;

import net.mcft.copy.betterstorage.inventory.InventoryBetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryStacks;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryTileEntity
extends InventoryBetterStorage {
    public final TileEntityContainer mainTileEntity;
    public final TileEntityContainer[] tileEntities;
    public final IInventory inventory;
    public final int columns;
    public final int rows;

    public InventoryTileEntity(TileEntityContainer mainTileEntity, TileEntityContainer[] tileEntities, IInventory inventory) {
        this.mainTileEntity = mainTileEntity;
        this.tileEntities = tileEntities;
        this.inventory = inventory;
        this.columns = mainTileEntity.getColumns();
        this.rows = inventory.getSizeInventory() / this.columns;
    }

    public InventoryTileEntity(TileEntityContainer mainTileEntity, TileEntityContainer ... tileEntities) {
        this(mainTileEntity, tileEntities, new InventoryStacks(InventoryTileEntity.getAllContents(tileEntities)));
    }

    public InventoryTileEntity(TileEntityContainer tileEntity, IInventory inventory) {
        this(tileEntity, new TileEntityContainer[]{tileEntity}, inventory);
    }

    public InventoryTileEntity(TileEntityContainer tileEntity) {
        this(tileEntity, new InventoryStacks(new ItemStack[][]{tileEntity.contents}));
    }

    private static ItemStack[][] getAllContents(TileEntityContainer ... tileEntities) {
        ItemStack[][] allContents = new ItemStack[tileEntities.length][];
        for (int i = 0; i < tileEntities.length; ++i) {
            allContents[i] = tileEntities[i].contents;
        }
        return allContents;
    }

    @Override
    public String getInventoryName() {
        return this.mainTileEntity.getContainerTitle();
    }

    @Override
    public boolean hasCustomInventoryName() {
        return !this.mainTileEntity.shouldLocalizeTitle();
    }

    public int getSizeInventory() {
        return this.inventory.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inventory.setInventorySlotContents(slot, stack);
        this.markDirty();
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return this.inventory.isItemValidForSlot(slot, stack);
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        for (TileEntityContainer tileEntity : this.tileEntities) {
            if (tileEntity.canPlayerUseContainer(player)) continue;
            return false;
        }
        return true;
    }

    public void openInventory() {
        this.mainTileEntity.onContainerOpened();
    }

    public void closeInventory() {
        this.mainTileEntity.onContainerClosed();
    }

    public void markDirty() {
        this.inventory.markDirty();
        for (TileEntityContainer te : this.tileEntities) {
            te.markDirtySuper();
        }
    }
}

