/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryWrapper
implements IInventory {
    public final IInventory base;
    private boolean overwriteName = false;
    private String title;
    private boolean localized;

    public InventoryWrapper(IInventory base) {
        this.base = base;
    }

    public InventoryWrapper(IInventory base, String title, boolean localized) {
        this(base);
        this.overwriteName = true;
        this.title = title;
        this.localized = localized;
    }

    public String getInventoryName() {
        return this.overwriteName ? this.title : this.base.getInventoryName();
    }

    public boolean hasCustomInventoryName() {
        return this.overwriteName ? this.localized : this.base.hasCustomInventoryName();
    }

    public int getSizeInventory() {
        return this.base.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.base.getStackInSlot(slot);
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return this.base.decrStackSize(slot, amount);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.base.setInventorySlotContents(slot, stack);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.base.getStackInSlotOnClosing(slot);
    }

    public int getInventoryStackLimit() {
        return this.base.getInventoryStackLimit();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.base.isUseableByPlayer(player);
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return this.base.isItemValidForSlot(slot, stack);
    }

    public void markDirty() {
        this.base.markDirty();
    }

    public void openInventory() {
        this.base.openInventory();
    }

    public void closeInventory() {
        this.base.closeInventory();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InventoryWrapper)) {
            return false;
        }
        InventoryWrapper inv = (InventoryWrapper)obj;
        return this.base.equals(inv.base);
    }
}

