/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.client.model.ModelBackpack;
import net.mcft.copy.betterstorage.client.model.ModelBackpackArmor;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.container.SlotArmorBackpack;
import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.inventory.InventoryBackpackEquipped;
import net.mcft.copy.betterstorage.inventory.InventoryStacks;
import net.mcft.copy.betterstorage.item.IDyeableItem;
import net.mcft.copy.betterstorage.item.ItemArmorBetterStorage;
import net.mcft.copy.betterstorage.misc.PropertiesBackpack;
import net.mcft.copy.betterstorage.misc.Resources;
import net.mcft.copy.betterstorage.misc.handlers.KeyBindingHandler;
import net.mcft.copy.betterstorage.network.packet.PacketBackpackHasItems;
import net.mcft.copy.betterstorage.tile.TileBackpack;
import net.mcft.copy.betterstorage.tile.entity.TileEntityBackpack;
import net.mcft.copy.betterstorage.utils.DirectionUtils;
import net.mcft.copy.betterstorage.utils.EntityUtils;
import net.mcft.copy.betterstorage.utils.LanguageUtils;
import net.mcft.copy.betterstorage.utils.PlayerUtils;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2FPacketSetSlot;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemBackpack
extends ItemArmorBetterStorage
implements ISpecialArmor,
IDyeableItem {
    public static final ItemArmor.ArmorMaterial material = EnumHelper.addArmorMaterial((String)"backpack", (int)14, (int[])new int[]{0, 2, 0, 0}, (int)15);
    @SideOnly(value=Side.CLIENT)
    private ModelBackpack model;
    @SideOnly(value=Side.CLIENT)
    private ModelBackpackArmor modelArmor;
    private static final String[] immuneToDamageType;

    protected ItemBackpack(ItemArmor.ArmorMaterial material) {
        super(material, 0, 1);
    }

    public ItemBackpack() {
        this(material);
    }

    public String getBackpackName() {
        return "container.betterstorage.backpack";
    }

    public int getBackpackColumns() {
        return 9;
    }

    public int getBackpackRows() {
        return BetterStorage.globalConfig.getInteger("general.backpackRows");
    }

    protected int getDefaultColor() {
        return 8409144;
    }

    protected IInventory getBackpackItemsInternal(EntityLivingBase carrier, EntityPlayer player) {
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData(carrier);
        int size = this.getBackpackColumns() * this.getBackpackRows();
        if (backpackData.contents == null) {
            backpackData.contents = new ItemStack[size];
        } else if (backpackData.contents.length != size) {
            ItemStack[] newContents = new ItemStack[size];
            System.arraycopy(backpackData.contents, 0, newContents, 0, Math.min(size, backpackData.contents.length));
            backpackData.contents = newContents;
        }
        return new InventoryStacks(this.getBackpackName(), (ItemStack[][])new ItemStack[][]{backpackData.contents});
    }

    public boolean containsItems(PropertiesBackpack backpackData) {
        return backpackData.hasItems || backpackData.contents != null && !StackUtils.isEmpty(backpackData.contents);
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends ModelBackpack> getModelClass() {
        return ModelBackpack.class;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBackpack getModel() {
        if (this.model == null) {
            try {
                this.model = this.getModelClass().getConstructor(Boolean.TYPE).newInstance(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.model;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack stack, int slot) {
        if (this.modelArmor == null) {
            try {
                ModelBackpack model = this.getModelClass().getConstructor(Boolean.TYPE).newInstance(false);
                this.modelArmor = new ModelBackpackArmor(model);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.modelArmor;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return (type == "overlay" ? Resources.textureBackpackOverlay : Resources.textureBackpack).toString();
    }

    @SideOnly(value=Side.CLIENT)
    public int getSpriteNumber() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
    }

    public String getUnlocalizedName() {
        return this.getBlockType().getUnlocalizedName();
    }

    public String getUnlocalizedName(ItemStack stack) {
        return this.getUnlocalizedName();
    }

    public TileBackpack getBlockType() {
        return BetterStorageTiles.backpack;
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return false;
    }

    public int getColor(ItemStack stack) {
        int color = this.getDefaultColor();
        return color >= 0 ? StackUtils.get(stack, color, "display", "color") : color;
    }

    public int getRenderPasses(int metadata) {
        return this.getDefaultColor() >= 0 ? 2 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        boolean enableHelpTooltips = BetterStorage.globalConfig.getBoolean("general.enableHelpTooltips");
        if (ItemBackpack.getBackpack((EntityLivingBase)player) == stack) {
            String info = LanguageUtils.translateTooltip(this.getAdditionalInfo(stack, player), new String[0]);
            if (ItemBackpack.isBackpackOpen((EntityLivingBase)player)) {
                if (info != null) {
                    list.add(info);
                }
                LanguageUtils.translateTooltip(list, "backpack.used", new String[0]);
            } else if (enableHelpTooltips) {
                String[] stringArray;
                String string = info != null ? "backpack.unequipHint.extended" : "backpack.unequipHint";
                if (info != null) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "%INFO%";
                    stringArray = stringArray2;
                    stringArray2[1] = info;
                } else {
                    stringArray = new String[]{};
                }
                LanguageUtils.translateTooltip(list, string, stringArray);
            } else if (info != null) {
                list.add(info);
            }
            if (BetterStorage.globalConfig.getBoolean("general.enableBackpackOpen")) {
                String str = GameSettings.getKeyDisplayString((int)KeyBindingHandler.backpackOpen.getKeyCode());
                LanguageUtils.translateTooltip(list, "backpack.openHint", "%KEY%", str);
            }
        } else if (enableHelpTooltips) {
            boolean chestplate = BetterStorage.globalConfig.getBoolean("general.backpackChestplate");
            LanguageUtils.translateTooltip(list, chestplate ? "backpack.equipHint" : "backpack.equipHint.extended", new String[0]);
            if (!chestplate && BetterStorage.globalConfig.getBoolean("general.enableBackpackOpen")) {
                String str = GameSettings.getKeyDisplayString((int)KeyBindingHandler.backpackOpen.getKeyCode());
                LanguageUtils.translateTooltip(list, "backpack.openHint", "%KEY%", str);
            }
        }
    }

    protected String getAdditionalInfo(ItemStack stack, EntityPlayer player) {
        return this.containsItems(ItemBackpack.getBackpackData((EntityLivingBase)player)) ? "backpack.containsItems" : null;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        int index = 5 + this.armorType;
        Slot slotBefore = player.inventoryContainer.getSlot(index);
        if (slotBefore instanceof SlotArmorBackpack) {
            return;
        }
        int slotIndex = player.inventory.getSizeInventory() - this.getChestSlotOffset(player) - this.armorType;
        SlotArmorBackpack slot = new SlotArmorBackpack((IInventory)player.inventory, slotIndex, 8, 8 + this.armorType * 18);
        slot.slotNumber = index;
        player.inventoryContainer.inventorySlots.set(index, slot);
    }

    private int getChestSlotOffset(EntityPlayer player) {
        return ItemBackpack.isExact(player.inventory, "micdoodle8.mods.galacticraft.core.inventory.GCCoreInventoryPlayer") ? 6 : 1;
    }

    private static boolean isExact(Object obj, String str) {
        try {
            return obj.getClass().getName().equals(str);
        }
        catch (Exception e) {
            return false;
        }
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        return stack;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        ForgeDirection orientation = DirectionUtils.getOrientation((Entity)player).getOpposite();
        return ItemBackpack.placeBackpack((EntityLivingBase)player, player, stack, x, y, z, side, orientation, false, false);
    }

    public void onEquippedUpdate(EntityLivingBase player, ItemStack backpack) {
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entity, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.08, armor.getMaxDamage() + 1 - armor.getItemDamage());
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 2;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (!this.takesDamage(stack, source)) {
            return;
        }
        stack.damageItem(damage, entity);
        if (stack.stackSize > 0) {
            return;
        }
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData(entity);
        if (backpackData.contents != null) {
            for (ItemStack s : backpackData.contents) {
                WorldUtils.dropStackFromEntity((Entity)entity, s, 2.0f);
            }
        }
        entity.renderBrokenItemStack(stack);
    }

    protected boolean takesDamage(ItemStack stack, DamageSource source) {
        if (source.isMagicDamage()) {
            return false;
        }
        for (String immune : immuneToDamageType) {
            if (!immune.equals(source.getDamageType())) continue;
            return false;
        }
        return !(this.enchantmentProtection(stack, Enchantment.protection, 0.3, 0.35, 0.4, 0.45) || source.isProjectile() && this.enchantmentProtection(stack, Enchantment.projectileProtection, 0.4, 0.5, 0.6, 0.7) || source.isFireDamage() && this.enchantmentProtection(stack, Enchantment.fireProtection, 0.55, 0.65, 0.75, 0.85) || source.isExplosion() && this.enchantmentProtection(stack, Enchantment.blastProtection, 0.65, 0.75, 0.85, 0.95));
    }

    private boolean enchantmentProtection(ItemStack stack, Enchantment ench, double ... chance) {
        int level = EnchantmentHelper.getEnchantmentLevel((int)ench.effectId, (ItemStack)stack);
        return (level = Math.min(level - 1, chance.length - 1)) >= 0 && RandomUtils.getBoolean(chance[level]);
    }

    @Override
    public boolean canDye(ItemStack stack) {
        return this.getDefaultColor() >= 0;
    }

    public static ItemStack getBackpack(EntityLivingBase entity) {
        ItemStack backpack = entity.getEquipmentInSlot(3);
        if (backpack != null && backpack.getItem() instanceof ItemBackpack) {
            return backpack;
        }
        return ItemBackpack.getBackpackData((EntityLivingBase)entity).backpack;
    }

    public static void setBackpack(EntityLivingBase entity, ItemStack backpack, ItemStack[] contents) {
        boolean setChestplate = BetterStorage.globalConfig.getBoolean("general.backpackChestplate") || !(entity instanceof EntityPlayer) || ItemBackpack.hasChestplateBackpackEquipped(entity);
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData(entity);
        if (!setChestplate) {
            backpackData.backpack = backpack;
        } else {
            entity.setCurrentItemOrArmor(3, backpack);
        }
        backpackData.contents = contents;
        ItemBackpack.updateHasItems(entity, backpackData);
    }

    public static boolean hasChestplateBackpackEquipped(EntityLivingBase entity) {
        ItemStack backpack = ItemBackpack.getBackpack(entity);
        return backpack != null ? backpack == entity.getEquipmentInSlot(3) : false;
    }

    public static boolean canEquipBackpack(EntityPlayer player) {
        return ItemBackpack.getBackpack((EntityLivingBase)player) == null && (!BetterStorage.globalConfig.getBoolean("general.backpackChestplate") || player.getEquipmentInSlot(3) == null);
    }

    public static IInventory getBackpackItems(EntityLivingBase carrier, EntityPlayer player) {
        ItemStack backpack = ItemBackpack.getBackpack(carrier);
        if (backpack == null) {
            return null;
        }
        return ((ItemBackpack)backpack.getItem()).getBackpackItemsInternal(carrier, player);
    }

    public static IInventory getBackpackItems(EntityLivingBase carrier) {
        return ItemBackpack.getBackpackItems(carrier, null);
    }

    public static void initBackpackData(EntityLivingBase entity) {
        EntityUtils.createProperties((Entity)entity, PropertiesBackpack.class);
    }

    public static PropertiesBackpack getBackpackData(EntityLivingBase entity) {
        PropertiesBackpack backpackData = EntityUtils.getOrCreateProperties((Entity)entity, PropertiesBackpack.class);
        if (!backpackData.initialized) {
            ItemBackpack.updateHasItems(entity, backpackData);
            backpackData.initialized = true;
        }
        return backpackData;
    }

    public static void updateHasItems(EntityLivingBase entity, PropertiesBackpack backpackData) {
        boolean hasItems;
        if (entity.worldObj.isRemote || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        boolean bl = hasItems = backpackData.contents != null && !StackUtils.isEmpty(backpackData.contents);
        if (backpackData.hasItems == hasItems) {
            return;
        }
        BetterStorage.networkChannel.sendTo(new PacketBackpackHasItems(hasItems), player);
        backpackData.hasItems = hasItems;
    }

    public static boolean isBackpackOpen(EntityLivingBase entity) {
        return ItemBackpack.getBackpackData((EntityLivingBase)entity).playersUsing > 0;
    }

    public static boolean openBackpack(EntityPlayer player, EntityLivingBase carrier) {
        ItemStack backpack = ItemBackpack.getBackpack(carrier);
        if (backpack == null) {
            return false;
        }
        ItemBackpack backpackType = (ItemBackpack)backpack.getItem();
        IInventory inventory = ItemBackpack.getBackpackItems(carrier, player);
        if (!(inventory = new InventoryBackpackEquipped(carrier, player, inventory)).isUseableByPlayer(player)) {
            return false;
        }
        int columns = backpackType.getBackpackColumns();
        int rows = backpackType.getBackpackRows();
        ContainerBetterStorage container = new ContainerBetterStorage(player, inventory, columns, rows);
        String title = StackUtils.get(backpack, "", "display", "Name");
        PlayerUtils.openGui(player, inventory.getInventoryName(), columns, rows, title, container);
        return true;
    }

    public static boolean onPlaceBackpack(EntityPlayer player, int x, int y, int z, int side) {
        if (player.getCurrentEquippedItem() != null || !player.isSneaking()) {
            return false;
        }
        ItemStack backpack = ItemBackpack.getBackpack((EntityLivingBase)player);
        if (backpack == null) {
            return false;
        }
        boolean success = false;
        if (!ItemBackpack.isBackpackOpen((EntityLivingBase)player)) {
            success = backpack.getItem().onItemUse(backpack, player, player.worldObj, x, y, z, side, 0.0f, 0.0f, 0.0f);
            if (backpack.stackSize <= 0) {
                ItemBackpack.setBackpack((EntityLivingBase)player, null, null);
                backpack = null;
            }
        }
        if (!player.worldObj.isRemote && success && player instanceof EntityPlayerMP && BetterStorage.globalConfig.getBoolean("general.backpackChestplate")) {
            ((EntityPlayerMP)player).playerNetServerHandler.sendPacket((Packet)new S2FPacketSetSlot(0, 6, backpack));
        }
        if (success) {
            player.swingItem();
        }
        return success;
    }

    public static boolean placeBackpack(EntityLivingBase carrier, EntityPlayer player, ItemStack backpack, int x, int y, int z, int side, ForgeDirection orientation, boolean despawn, boolean deathDrop) {
        if (backpack.stackSize == 0) {
            return false;
        }
        World world = carrier.worldObj;
        TileBackpack blockBackpack = ((ItemBackpack)backpack.getItem()).getBlockType();
        if (y <= 0 || y >= world.getHeight() - 1) {
            return false;
        }
        if (!world.getBlock(x, y, z).isReplaceable((IBlockAccess)world, x, y, z)) {
            if (side != 1) {
                return false;
            }
            ++y;
        }
        Block blockBelow = world.getBlock(x, y - 1, z);
        if (deathDrop ? blockBelow.isReplaceable((IBlockAccess)world, x, y - 1, z) : !world.isSideSolid(x, y - 1, z, ForgeDirection.UP)) {
            return false;
        }
        if (!world.canPlaceEntityOnSide((Block)blockBackpack, x, y, z, deathDrop, side, (Entity)carrier, backpack)) {
            return false;
        }
        if (!(player == null || world.canMineBlock(player, x, y, z) && player.canPlayerEdit(x, y, z, side, backpack))) {
            return false;
        }
        if (world.isRemote) {
            return true;
        }
        if (!world.setBlock(x, y, z, (Block)blockBackpack, orientation.ordinal(), 3)) {
            return false;
        }
        if (world.getBlock(x, y, z) != blockBackpack) {
            return false;
        }
        blockBackpack.onBlockPlacedBy(world, x, y, z, carrier, backpack);
        blockBackpack.onPostBlockPlaced(world, x, y, z, orientation.ordinal());
        TileEntityBackpack te = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityBackpack.class);
        te.stack = backpack.copy();
        if (ItemBackpack.getBackpack(carrier) == backpack) {
            te.unequip(carrier, despawn);
        }
        String sound = blockBackpack.stepSound.func_150496_b();
        float volume = (blockBackpack.stepSound.getVolume() + 1.0f) / 2.0f;
        float pitch = blockBackpack.stepSound.getPitch() * 0.8f;
        world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)((float)z + 0.5f), sound, volume, pitch);
        --backpack.stackSize;
        return true;
    }

    static {
        ItemBackpack.material.customCraftingMaterial = Items.leather;
        immuneToDamageType = new String[]{"inWall", "drown", "starve", "cactus", "fall", "outOfWorld", "generic", "wither", "anvil", "fallingBlock", "thrown"};
    }
}

