/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.client.model.ModelDrinkingHelmet;
import net.mcft.copy.betterstorage.item.ItemArmorBetterStorage;
import net.mcft.copy.betterstorage.misc.Resources;
import net.mcft.copy.betterstorage.misc.SmallPotionEffect;
import net.mcft.copy.betterstorage.misc.handlers.KeyBindingHandler;
import net.mcft.copy.betterstorage.utils.LanguageUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.EnumHelper;

public class ItemDrinkingHelmet
extends ItemArmorBetterStorage {
    private IIcon iconPotions;
    public static final int maxUses = 12;
    public static final ItemArmor.ArmorMaterial material = EnumHelper.addArmorMaterial((String)"drinkingHelmet", (int)11, (int[])new int[]{3, 0, 0, 0}, (int)15);

    public ItemDrinkingHelmet() {
        super(material, 0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("betterstorage:" + this.getItemName());
        this.iconPotions = iconRegister.registerIcon("betterstorage:" + this.getItemName() + "_potions");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return StackUtils.get(stack, 0, "uses") > 0 ? this.iconPotions : this.itemIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconIndex(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return Resources.textureDrinkingHelmet.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack stack, int slot) {
        return ModelDrinkingHelmet.instance;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return StackUtils.has(stack, "display", "Lore") ? EnumRarity.epic : EnumRarity.rare;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        int uses = StackUtils.get(stack, 0, "uses");
        if (uses > 0 && ItemDrinkingHelmet.getDrinkingHelmet((EntityLivingBase)player) == stack) {
            String str = GameSettings.getKeyDisplayString((int)KeyBindingHandler.drinkingHelmet.getKeyCode());
            LanguageUtils.translateTooltip(list, "drinkingHelmet.useHint", "%KEY%", str);
        }
        for (ItemStack potion : ItemDrinkingHelmet.getPotions(stack)) {
            if (potion == null) continue;
            String name = potion.getDisplayName();
            if (list.size() > 0 && list.get(list.size() - 1).equals(EnumChatFormatting.DARK_AQUA + name)) {
                list.set(list.size() - 1, EnumChatFormatting.DARK_AQUA + "2x " + name);
                continue;
            }
            list.add(EnumChatFormatting.DARK_AQUA + name);
        }
        if (uses > 0) {
            list.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + LanguageUtils.translateTooltip("drinkingHelmet.uses", "%USES%", Integer.toString(uses)));
        } else if (BetterStorage.globalConfig.getBoolean("general.enableHelpTooltips")) {
            list.add(LanguageUtils.translateTooltip("drinkingHelmet.craftHint", new String[0]));
        }
    }

    public static ItemStack[] getPotions(ItemStack drinkingHelmet) {
        return StackUtils.getStackContents(drinkingHelmet, 2);
    }

    public static void setPotions(ItemStack drinkingHelmet, ItemStack[] potions) {
        if (potions != null) {
            StackUtils.setStackContents(drinkingHelmet, potions);
            StackUtils.set(drinkingHelmet, 12, "uses");
        } else {
            StackUtils.remove(drinkingHelmet, "Items");
            StackUtils.remove(drinkingHelmet, "uses");
        }
    }

    public static ItemStack getDrinkingHelmet(EntityLivingBase entity) {
        ItemStack drinkingHelmet = entity.getEquipmentInSlot(4);
        if (drinkingHelmet != null && drinkingHelmet.getItem() instanceof ItemDrinkingHelmet) {
            return drinkingHelmet;
        }
        return null;
    }

    public static void use(EntityPlayer player) {
        ItemStack drinkingHelmet = ItemDrinkingHelmet.getDrinkingHelmet((EntityLivingBase)player);
        if (drinkingHelmet == null) {
            return;
        }
        int uses = StackUtils.get(drinkingHelmet, 0, "uses");
        if (uses <= 0) {
            return;
        }
        ItemStack[] potions = StackUtils.getStackContents(drinkingHelmet, 2);
        ArrayList potionEffects = new ArrayList();
        for (ItemStack item : potions) {
            List effects;
            if (!(item.getItem() instanceof ItemPotion) || (effects = ((ItemPotion)item.getItem()).getEffects(item)) == null) continue;
            potionEffects.addAll(effects);
        }
        for (PotionEffect effect : potionEffects) {
            Potion potion = Potion.potionTypes[effect.getPotionID()];
            PotionEffect active = player.getActivePotionEffect(potion);
            effect = new SmallPotionEffect(effect, active);
            player.addPotionEffect(effect);
        }
        player.worldObj.playSoundAtEntity((Entity)player, "random.drink", 0.5f, 0.9f + player.worldObj.rand.nextFloat() * 0.1f);
        if (--uses <= 0) {
            ItemDrinkingHelmet.setPotions(drinkingHelmet, null);
        } else {
            StackUtils.set(drinkingHelmet, uses, "uses");
        }
    }

    static {
        ItemDrinkingHelmet.material.customCraftingMaterial = Item.getItemFromBlock((Block)Blocks.redstone_block);
    }
}

