/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.cardboard;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.item.ItemArmorBetterStorage;
import net.mcft.copy.betterstorage.item.cardboard.ICardboardItem;
import net.mcft.copy.betterstorage.item.cardboard.ItemCardboardSheet;
import net.mcft.copy.betterstorage.misc.Resources;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;

public class ItemCardboardArmor
extends ItemArmorBetterStorage
implements ICardboardItem,
ISpecialArmor {
    private static final String[] armorText = new String[]{"Helmet", "Chestplate", "Leggings", "Boots"};

    public ItemCardboardArmor(int armorType) {
        super(ItemCardboardSheet.armorMaterial, 0, armorType);
    }

    @Override
    public String getItemName() {
        return "cardboard" + armorText[this.armorType];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("betterstorage:" + this.getItemName());
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return (type != null ? Resources.textureEmpty : (slot == 2 ? Resources.textureCardboardLeggins : Resources.textureCardboardArmor)).toString();
    }

    public int getColor(ItemStack stack) {
        return StackUtils.get(stack, 7360560, "display", "color");
    }

    @Override
    public boolean canDye(ItemStack stack) {
        return true;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, (double)this.damageReduceAmount / 25.0, armor.getMaxDamage() - armor.getItemDamage());
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return armor.getItemDamage() < armor.getMaxDamage() ? this.damageReduceAmount : 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ItemCardboardSheet.damageItem(stack, damage, entity);
    }
}

