/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.cardboard;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.item.cardboard.ICardboardItem;
import net.mcft.copy.betterstorage.item.cardboard.ItemCardboardSheet;
import net.mcft.copy.betterstorage.utils.MiscUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemCardboardHoe
extends ItemHoe
implements ICardboardItem {
    private String name;

    public ItemCardboardHoe() {
        super(ItemCardboardSheet.toolMaterial);
        this.setCreativeTab(BetterStorage.creativeTab);
        this.setUnlocalizedName("betterstorage." + this.getItemName());
        GameRegistry.registerItem((Item)this, (String)this.getItemName());
    }

    public String getItemName() {
        return this.name != null ? this.name : (this.name = MiscUtils.getName((Item)this));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("betterstorage:" + this.getItemName());
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        return StackUtils.get(stack, 7360560, "display", "color");
    }

    @Override
    public boolean canDye(ItemStack stack) {
        return true;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return ItemCardboardSheet.canHarvestBlock(stack, super.canHarvestBlock(block, stack));
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return !ItemCardboardSheet.isEffective(stack);
    }

    public boolean onBlockDestroyed(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase player) {
        return ItemCardboardSheet.onBlockDestroyed(world, block, x, y, z, stack, player);
    }

    public boolean hitEntity(ItemStack stack, EntityLivingBase target, EntityLivingBase player) {
        return ItemCardboardSheet.damageItem(stack, 1, player);
    }
}

