/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.locking;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.api.BetterStorageEnchantment;
import net.mcft.copy.betterstorage.api.lock.IKey;
import net.mcft.copy.betterstorage.api.lock.ILock;
import net.mcft.copy.betterstorage.item.ItemBetterStorage;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemKey
extends ItemBetterStorage
implements IKey {
    private IIcon iconColor;
    private IIcon iconFullColor;

    public ItemKey() {
        this.setContainerItem(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        super.registerIcons(iconRegister);
        this.iconColor = iconRegister.registerIcon("betterstorage:key_color");
        this.iconFullColor = iconRegister.registerIcon("betterstorage:key_fullColor");
    }

    public boolean isDamageable() {
        return true;
    }

    public int getItemEnchantability() {
        return 20;
    }

    public boolean doesContainerItemLeaveCraftingGrid(ItemStack stack) {
        return false;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack;
    }

    public void onCreated(ItemStack stack, World world, EntityPlayer player) {
        if (!world.isRemote) {
            ItemKey.ensureHasID(stack);
        }
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean isBeingHeld) {
        if (!world.isRemote) {
            ItemKey.ensureHasID(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        int fullColor = ItemKey.getFullColor(stack);
        if (fullColor < 0) {
            fullColor = 0xFFFFFF;
        }
        if (renderPass > 0) {
            int color = ItemKey.getColor(stack);
            return color < 0 ? fullColor : color;
        }
        return fullColor;
    }

    public IIcon getIcon(ItemStack stack, int renderPass) {
        boolean hasFullColor;
        boolean bl = hasFullColor = ItemKey.getFullColor(stack) >= 0;
        if (renderPass > 0 && ItemKey.getColor(stack) >= 0) {
            return this.iconColor;
        }
        return hasFullColor ? this.iconFullColor : this.itemIcon;
    }

    public static void ensureHasID(ItemStack stack) {
        if (!StackUtils.has(stack, "id")) {
            ItemKey.setID(stack, RandomUtils.getInt(1, 32000));
        }
    }

    @Override
    public boolean isNormalKey() {
        return true;
    }

    @Override
    public boolean unlock(ItemStack key, ItemStack lock, boolean useAbility) {
        int div;
        int keyId;
        ILock lockType = (ILock)lock.getItem();
        if (lockType.getLockType() != "normal") {
            return false;
        }
        int lockId = ItemKey.getID(lock);
        if (lockId == (keyId = ItemKey.getID(key))) {
            return true;
        }
        int lockSecurity = BetterStorageEnchantment.getLevel(lock, "security");
        int unlocking = BetterStorageEnchantment.getLevel(key, "unlocking");
        int lockpicking = BetterStorageEnchantment.getLevel(key, "lockpicking");
        int morphing = BetterStorageEnchantment.getLevel(key, "morphing");
        int effectiveUnlocking = Math.max(0, unlocking - lockSecurity);
        int effectiveLockpicking = Math.max(0, lockpicking - lockSecurity);
        int effectiveMorphing = Math.max(0, morphing - lockSecurity);
        if (effectiveUnlocking > 0 && lockId / (div = (int)Math.pow(2.0, 10 + effectiveUnlocking * 1)) == keyId / div) {
            return true;
        }
        if (useAbility && effectiveLockpicking > 0) {
            NBTTagList list = key.getEnchantmentTagList();
            for (int i = 0; i < list.tagCount(); ++i) {
                NBTTagCompound compound = list.getCompoundTagAt(i);
                if (compound.getShort("id") != BetterStorageEnchantment.get((String)"lockpicking").effectId) continue;
                int level = compound.getShort("lvl") - 1;
                if (level == 0) {
                    list.removeTag(i);
                    if (list.tagCount() != 0) break;
                    key.getTagCompound().removeTag("ench");
                    break;
                }
                compound.setShort("lvl", (short)level);
                break;
            }
            return true;
        }
        if (useAbility && effectiveMorphing > 0) {
            key.setItemDamage(lockId);
            NBTTagList list = key.getEnchantmentTagList();
            for (int i = 0; i < list.tagCount(); ++i) {
                NBTTagCompound compound = list.getCompoundTagAt(i);
                if (compound.getShort("id") != BetterStorageEnchantment.get((String)"morphing").effectId) continue;
                list.removeTag(i);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canApplyEnchantment(ItemStack key, Enchantment enchantment) {
        return true;
    }
}

