/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc;

import java.util.Random;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.item.ItemDrinkingHelmet;
import net.mcft.copy.betterstorage.utils.NbtUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public final class DungeonLoot {
    private DungeonLoot() {
    }

    public static void add() {
        if (BetterStorageItems.drinkingHelmet != null) {
            ItemStack drinkingHelmet = new ItemStack((Item)BetterStorageItems.drinkingHelmet);
            DungeonLoot.addMultiple(drinkingHelmet, "dungeonChest", 1.0, "pyramidDesertyChest", 2.0, "pyramidJungleChest", 2.0, "strongholdCorridor", 1.0, "strongholdCrossing", 1.0);
            ItemStack drinkingHelmetSpecial = new ItemStack((Item)BetterStorageItems.drinkingHelmet);
            drinkingHelmetSpecial.setStackDisplayName("Nishmet");
            ItemStack fireResPotion = new ItemStack((Item)Items.potionitem, 1, 8259);
            ItemStack healPotion = new ItemStack((Item)Items.potionitem, 1, 8229);
            ItemDrinkingHelmet.setPotions(drinkingHelmetSpecial, new ItemStack[]{fireResPotion, healPotion});
            drinkingHelmetSpecial.addEnchantment(Enchantment.fireProtection, 5);
            drinkingHelmetSpecial.addEnchantment(Enchantment.fireAspect, 3);
            drinkingHelmetSpecial.addEnchantment(Enchantment.unbreaking, 2);
            NBTTagList drinkingHelmetLore = NbtUtils.createList("\"i fail at names for items\" -Nishtown");
            StackUtils.set(drinkingHelmetSpecial, (NBTBase)drinkingHelmetLore, "display", "Lore");
            DungeonLoot.addMultiple(drinkingHelmetSpecial, "pyramidDesertyChest", 0.2);
        }
        if (BetterStorageTiles.backpack != null) {
            ItemStack backpackSpecial1 = new ItemStack((Item)BetterStorageItems.itemBackpack);
            backpackSpecial1.setStackDisplayName("Everlasting Backpack");
            backpackSpecial1.addEnchantment(Enchantment.unbreaking, 4);
            StackUtils.set(backpackSpecial1, 26146, "display", "color");
            DungeonLoot.addMultiple(backpackSpecial1, "pyramidJungleChest", 0.5);
            ItemStack backpackSpecial2 = new ItemStack((Item)BetterStorageItems.itemBackpack);
            backpackSpecial2.setStackDisplayName("Shielding Backpack");
            backpackSpecial2.addEnchantment(Enchantment.protection, 5);
            StackUtils.set(backpackSpecial2, 187, "display", "color");
            DungeonLoot.addMultiple(backpackSpecial2, "pyramidDesertyChest", 0.4);
        }
    }

    private static void addMultiple(ItemStack stack, Object ... args) {
        for (int i = 0; i < args.length; i += 2) {
            ChestGenHooks.addItem((String)((String)args[i]), (WeightedRandomChestContent)DungeonLoot.makeItem(stack, (Double)args[i + 1]));
        }
    }

    private static WeightedRandomChestContent makeItem(ItemStack stack, double chance) {
        if (chance < 1.0) {
            return new RareChestContent(stack, chance);
        }
        return new WeightedRandomChestContent(stack, 1, 1, (int)chance);
    }

    private static class RareChestContent
    extends WeightedRandomChestContent {
        private final double chance;

        public RareChestContent(ItemStack stack, double chance) {
            super(stack, 1, 1, 1);
            this.chance = chance;
        }

        protected ItemStack[] generateChestContent(Random random, IInventory newInventory) {
            if (random.nextDouble() >= this.chance) {
                return new ItemStack[0];
            }
            return super.generateChestContent(random, newInventory);
        }
    }
}

