/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc;

import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.network.packet.PacketBackpackIsOpen;
import net.mcft.copy.betterstorage.network.packet.PacketBackpackStack;
import net.mcft.copy.betterstorage.utils.NbtUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PropertiesBackpack
implements IExtendedEntityProperties {
    public static final String identifier = "betterstorage.backpack";
    public ItemStack backpack = null;
    public ItemStack[] contents = null;
    public boolean initialized = false;
    public boolean spawnsWithBackpack = false;
    public int playersUsing = 0;
    public boolean hasItems = false;
    public float lidAngle = 0.0f;
    public float prevLidAngle = 0.0f;
    private ItemStack prevBackpack = null;
    private int prevPlayersUsing = 0;

    public void init(Entity entity, World world) {
    }

    public void saveNBTData(NBTTagCompound compound) {
        if (this.contents == null) {
            return;
        }
        NBTTagCompound backpackCompound = new NBTTagCompound();
        backpackCompound.setInteger("count", this.contents.length);
        backpackCompound.setTag("Items", (NBTBase)NbtUtils.writeItems(this.contents));
        if (this.backpack != null) {
            backpackCompound.setTag("Stack", (NBTBase)this.backpack.writeToNBT(new NBTTagCompound()));
        }
        compound.setTag("Backpack", (NBTBase)backpackCompound);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.backpack = null;
        this.contents = null;
        if (compound.hasKey("Backpack")) {
            NBTTagCompound backpackCompound = compound.getCompoundTag("Backpack");
            this.backpack = ItemStack.loadItemStackFromNBT((NBTTagCompound)backpackCompound.getCompoundTag("Stack"));
            this.contents = new ItemStack[backpackCompound.getInteger("count")];
            NbtUtils.readItems(this.contents, backpackCompound.getTagList("Items", 10));
        }
    }

    public void update(EntityLivingBase entity) {
        this.prevLidAngle = this.lidAngle;
        float lidSpeed = 0.2f;
        this.lidAngle = this.playersUsing > 0 ? Math.min(1.0f, this.lidAngle + lidSpeed) : Math.max(0.0f, this.lidAngle - lidSpeed);
        if (!entity.worldObj.isRemote) {
            boolean isOpen;
            String sound = Block.soundTypeSnow.getStepResourcePath();
            if (this.lidAngle > 0.0f && this.prevLidAngle <= 0.0f) {
                entity.worldObj.playSoundEffect(entity.posX, entity.posY, entity.posZ, sound, 1.0f, 0.6f);
            }
            if (this.lidAngle < 0.2f && this.prevLidAngle >= 0.2f) {
                entity.worldObj.playSoundEffect(entity.posX, entity.posY, entity.posZ, sound, 0.8f, 0.4f);
            }
            if ((isOpen = this.playersUsing > 0) != this.prevPlayersUsing > 0) {
                BetterStorage.networkChannel.sendToAndAllTracking(new PacketBackpackIsOpen(entity.getEntityId(), isOpen), (Entity)entity);
                this.prevPlayersUsing = this.playersUsing;
            }
            if (!ItemStack.areItemStacksEqual((ItemStack)this.backpack, (ItemStack)this.prevBackpack)) {
                BetterStorage.networkChannel.sendToAndAllTracking(new PacketBackpackStack(entity.getEntityId(), this.backpack), (Entity)entity);
                this.prevBackpack = ItemStack.copyItemStack((ItemStack)this.backpack);
            }
        }
    }

    public void sendDataToPlayer(EntityLivingBase entity, EntityPlayer player) {
        if (this.playersUsing > 0) {
            BetterStorage.networkChannel.sendTo(new PacketBackpackIsOpen(entity.getEntityId(), true), player);
        }
        if (this.backpack != null) {
            BetterStorage.networkChannel.sendTo(new PacketBackpackStack(entity.getEntityId(), this.backpack), player);
        }
    }
}

