/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc;

import cpw.mods.fml.common.registry.GameRegistry;
import net.mcft.copy.betterstorage.addon.Addon;
import net.mcft.copy.betterstorage.api.crafting.BetterStorageCrafting;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.item.cardboard.CardboardEnchantmentRecipe;
import net.mcft.copy.betterstorage.item.cardboard.CardboardRepairRecipe;
import net.mcft.copy.betterstorage.item.recipe.DrinkingHelmetRecipe;
import net.mcft.copy.betterstorage.item.recipe.DyeRecipe;
import net.mcft.copy.betterstorage.item.recipe.KeyRecipe;
import net.mcft.copy.betterstorage.item.recipe.LockColorRecipe;
import net.mcft.copy.betterstorage.item.recipe.LockRecipe;
import net.mcft.copy.betterstorage.item.recipe.PresentRecipe;
import net.mcft.copy.betterstorage.item.recipe.PresentRemoveNametagRecipe;
import net.mcft.copy.betterstorage.tile.ContainerMaterial;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;

public final class Recipes {
    private Recipes() {
    }

    public static void add() {
        Recipes.registerRecipeSorter();
        Recipes.addTileRecipes();
        Recipes.addItemRecipes();
        Recipes.addCardboardRecipes();
        GameRegistry.addRecipe((IRecipe)new DyeRecipe());
        Addon.addRecipesAll();
    }

    private static void registerRecipeSorter() {
        RecipeSorter.register((String)"betterstorage:drinkinghelmetrecipe", DrinkingHelmetRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"betterstorage:keyrecipe", KeyRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"betterstorage:lockrecipe", LockRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"betterstorage:dyerecipe", DyeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        RecipeSorter.register((String)"betterstorage:lockcolorrecipe", LockColorRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
    }

    private static void addTileRecipes() {
        ShapedOreRecipe recipe;
        if (BetterStorageTiles.crate != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)BetterStorageTiles.crate), new Object[]{"o/o", "/ /", "o/o", Character.valueOf('o'), "plankWood", Character.valueOf('/'), "stickWood"}));
        }
        if (BetterStorageTiles.reinforcedChest != null) {
            for (ContainerMaterial material : ContainerMaterial.getMaterials()) {
                recipe = material.getReinforcedRecipe((Block)Blocks.chest, BetterStorageTiles.reinforcedChest);
                if (recipe == null) continue;
                GameRegistry.addRecipe((IRecipe)recipe);
            }
        }
        if (BetterStorageTiles.locker != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)BetterStorageTiles.locker), new Object[]{"ooo", "o |", "ooo", Character.valueOf('o'), "plankWood", Character.valueOf('|'), Blocks.trapdoor}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)BetterStorageTiles.locker), new Object[]{"ooo", "| o", "ooo", Character.valueOf('o'), "plankWood", Character.valueOf('|'), Blocks.trapdoor}));
            if (BetterStorageTiles.reinforcedLocker != null) {
                for (ContainerMaterial material : ContainerMaterial.getMaterials()) {
                    recipe = material.getReinforcedRecipe(BetterStorageTiles.locker, BetterStorageTiles.reinforcedLocker);
                    if (recipe == null) continue;
                    GameRegistry.addRecipe((IRecipe)recipe);
                }
            }
        }
        if (BetterStorageTiles.armorStand != null) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)BetterStorageTiles.armorStand), (Object[])new Object[]{" i ", "/i/", " s ", Character.valueOf('s'), new ItemStack((Block)Blocks.stone_slab, 1, 0), Character.valueOf('i'), Items.iron_ingot, Character.valueOf('/'), Items.stick});
        }
        if (BetterStorageTiles.backpack != null) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)BetterStorageItems.itemBackpack), (Object[])new Object[]{"#i#", "#O#", "###", Character.valueOf('#'), Items.leather, Character.valueOf('O'), Blocks.wool, Character.valueOf('i'), Items.gold_ingot});
        }
        if (BetterStorageTiles.cardboardBox != null && BetterStorageItems.cardboardSheet != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)BetterStorageTiles.cardboardBox), new Object[]{"ooo", "o o", "ooo", Character.valueOf('o'), "sheetCardboard"}));
        }
        if (BetterStorageTiles.craftingStation != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)BetterStorageTiles.craftingStation), new Object[]{"B-B", "PTP", "WCW", Character.valueOf('B'), Blocks.stonebrick, Character.valueOf('-'), Blocks.light_weighted_pressure_plate, Character.valueOf('P'), Blocks.piston, Character.valueOf('T'), Blocks.crafting_table, Character.valueOf('W'), "plankWood", Character.valueOf('C'), BetterStorageTiles.crate != null ? BetterStorageTiles.crate : Blocks.chest}));
        }
        if (BetterStorageTiles.present != null && BetterStorageTiles.cardboardBox != null) {
            GameRegistry.addRecipe((IRecipe)new PresentRecipe());
            BetterStorageCrafting.addStationRecipe(new PresentRemoveNametagRecipe());
        }
        if (BetterStorageTiles.flintBlock != null) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)BetterStorageTiles.flintBlock), (Object[])new Object[]{"ooo", "ooo", "ooo", Character.valueOf('o'), Items.flint});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.flint, 9), (Object[])new Object[]{BetterStorageTiles.flintBlock});
        }
    }

    private static void addItemRecipes() {
        if (BetterStorageItems.key != null) {
            GameRegistry.addRecipe((IRecipe)KeyRecipe.createKeyRecipe(".o", ".o", " o", Character.valueOf('o'), Items.gold_ingot, Character.valueOf('.'), Items.gold_nugget));
            GameRegistry.addRecipe((IRecipe)KeyRecipe.createKeyRecipe("k", Character.valueOf('k'), new ItemStack((Item)BetterStorageItems.key)));
        }
        if (BetterStorageItems.lock != null) {
            if (BetterStorageItems.key != null) {
                GameRegistry.addRecipe((IRecipe)LockRecipe.createLockRecipe());
            }
            GameRegistry.addRecipe((IRecipe)LockColorRecipe.createLockColorRecipe());
        }
        if (BetterStorageItems.keyring != null) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)BetterStorageItems.keyring), (Object[])new Object[]{"...", ". .", "...", Character.valueOf('.'), Items.gold_nugget});
        }
        if (BetterStorageItems.drinkingHelmet != null) {
            GameRegistry.addRecipe((IRecipe)new DrinkingHelmetRecipe((Item)BetterStorageItems.drinkingHelmet));
        }
    }

    private static void addCardboardRecipes() {
        if (BetterStorageItems.cardboardSheet != null) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)BetterStorageItems.cardboardSheet, 4), (Object[])new Object[]{Items.paper, Items.paper, Items.paper, Items.paper, Items.paper, Items.paper, Items.paper, Items.paper, Items.slime_ball});
        }
        if (BetterStorageItems.cardboardHelmet != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BetterStorageItems.cardboardHelmet), new Object[]{"ooo", "o o", Character.valueOf('o'), "sheetCardboard"}));
        }
        if (BetterStorageItems.cardboardChestplate != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BetterStorageItems.cardboardChestplate), new Object[]{"o o", "ooo", "ooo", Character.valueOf('o'), "sheetCardboard"}));
        }
        if (BetterStorageItems.cardboardLeggings != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BetterStorageItems.cardboardLeggings), new Object[]{"ooo", "o o", "o o", Character.valueOf('o'), "sheetCardboard"}));
        }
        if (BetterStorageItems.cardboardBoots != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BetterStorageItems.cardboardBoots), new Object[]{"o o", "o o", Character.valueOf('o'), "sheetCardboard"}));
        }
        if (BetterStorageItems.cardboardSword != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BetterStorageItems.cardboardSword), new Object[]{"o", "o", "/", Character.valueOf('o'), "sheetCardboard", Character.valueOf('/'), Items.stick}));
        }
        if (BetterStorageItems.cardboardPickaxe != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BetterStorageItems.cardboardPickaxe), new Object[]{"ooo", " / ", " / ", Character.valueOf('o'), "sheetCardboard", Character.valueOf('/'), Items.stick}));
        }
        if (BetterStorageItems.cardboardShovel != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BetterStorageItems.cardboardShovel), new Object[]{"o", "/", "/", Character.valueOf('o'), "sheetCardboard", Character.valueOf('/'), Items.stick}));
        }
        if (BetterStorageItems.cardboardAxe != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BetterStorageItems.cardboardAxe), new Object[]{"oo", "o/", " /", Character.valueOf('o'), "sheetCardboard", Character.valueOf('/'), Items.stick}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BetterStorageItems.cardboardAxe), new Object[]{"oo", "/o", "/ ", Character.valueOf('o'), "sheetCardboard", Character.valueOf('/'), Items.stick}));
        }
        if (BetterStorageItems.cardboardHoe != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BetterStorageItems.cardboardHoe), new Object[]{"oo", " /", " /", Character.valueOf('o'), "sheetCardboard", Character.valueOf('/'), Items.stick}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BetterStorageItems.cardboardHoe), new Object[]{"oo", "/ ", "/ ", Character.valueOf('o'), "sheetCardboard", Character.valueOf('/'), Items.stick}));
        }
        if (BetterStorageItems.anyCardboardItemsEnabled) {
            BetterStorageCrafting.addStationRecipe(new CardboardEnchantmentRecipe());
            if (BetterStorageItems.cardboardSheet != null) {
                BetterStorageCrafting.addStationRecipe(new CardboardRepairRecipe());
            }
        }
    }
}

