/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class Region {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;

    public int width() {
        return this.maxX - this.minX + 1;
    }

    public int depth() {
        return this.maxY - this.minY + 1;
    }

    public int height() {
        return this.maxZ - this.minZ + 1;
    }

    public int volume() {
        return this.width() * this.depth() * this.height();
    }

    public Region(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Region(TileEntity entity) {
        this(entity.xCoord, entity.yCoord, entity.zCoord, entity.xCoord, entity.yCoord, entity.zCoord);
    }

    public void set(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public void expand(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX -= minX;
        this.minY -= minY;
        this.minZ -= minZ;
        this.maxX += maxX;
        this.maxY += maxY;
        this.maxZ += maxZ;
    }

    public void expand(int size) {
        this.expand(size, size, size, size, size, size);
    }

    public boolean contains(int x, int y, int z) {
        return x >= this.minX && y >= this.minY && z >= this.minZ && x <= this.maxX && y <= this.maxY && z <= this.maxZ;
    }

    public boolean contains(TileEntity entity) {
        return this.contains(entity.xCoord, entity.yCoord, entity.zCoord);
    }

    public void expandToContain(int x, int y, int z) {
        this.minX = Math.min(this.minX, x);
        this.minY = Math.min(this.minY, y);
        this.minZ = Math.min(this.minZ, z);
        this.maxX = Math.max(this.maxX, x);
        this.maxY = Math.max(this.maxY, y);
        this.maxZ = Math.max(this.maxZ, z);
    }

    public void expandToContain(TileEntity entity) {
        this.expandToContain(entity.xCoord, entity.yCoord, entity.zCoord);
    }

    public NBTTagCompound toCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.setInteger("minX", this.minX);
        compound.setInteger("minY", this.minY);
        compound.setInteger("minZ", this.minZ);
        compound.setInteger("maxX", this.maxX);
        compound.setInteger("maxY", this.maxY);
        compound.setInteger("maxZ", this.maxZ);
        return compound;
    }

    public static Region fromCompound(NBTTagCompound compound) {
        int minX = compound.getInteger("minX");
        int minY = compound.getInteger("minY");
        int minZ = compound.getInteger("minZ");
        int maxX = compound.getInteger("maxX");
        int maxY = compound.getInteger("maxY");
        int maxZ = compound.getInteger("maxZ");
        return new Region(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Region clone() {
        return new Region(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public String toString() {
        return "[ " + this.minX + "," + this.minY + "," + this.minZ + " : " + this.maxX + "," + this.maxY + "," + this.maxZ + " ]";
    }
}

