/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import net.mcft.copy.betterstorage.network.packet.PacketBackpackHasItems;
import net.mcft.copy.betterstorage.network.packet.PacketBackpackIsOpen;
import net.mcft.copy.betterstorage.network.packet.PacketBackpackOpen;
import net.mcft.copy.betterstorage.network.packet.PacketBackpackStack;
import net.mcft.copy.betterstorage.network.packet.PacketBackpackTeleport;
import net.mcft.copy.betterstorage.network.packet.PacketDrinkingHelmetUse;
import net.mcft.copy.betterstorage.network.packet.PacketLockHit;
import net.mcft.copy.betterstorage.network.packet.PacketOpenGui;
import net.mcft.copy.betterstorage.network.packet.PacketPresentOpen;
import net.mcft.copy.betterstorage.network.packet.PacketSyncSetting;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ChannelHandler
extends SimpleNetworkWrapper {
    public ChannelHandler() {
        super("betterstorage");
        this.register(0, Side.CLIENT, PacketOpenGui.class);
        this.register(1, Side.CLIENT, PacketBackpackTeleport.class);
        this.register(2, Side.CLIENT, PacketBackpackHasItems.class);
        this.register(3, Side.CLIENT, PacketBackpackIsOpen.class);
        this.register(4, Side.SERVER, PacketBackpackOpen.class);
        this.register(5, Side.CLIENT, PacketBackpackStack.class);
        this.register(6, Side.SERVER, PacketDrinkingHelmetUse.class);
        this.register(7, Side.SERVER, PacketLockHit.class);
        this.register(8, Side.CLIENT, PacketSyncSetting.class);
        this.register(9, Side.CLIENT, PacketPresentOpen.class);
    }

    public <T extends IMessage & IMessageHandler<T, IMessage>> void register(int id, Side receivingSide, Class<T> messageClass) {
        this.registerMessage(messageClass, messageClass, id, receivingSide);
    }

    public void sendTo(IMessage message, EntityPlayer player) {
        this.sendTo(message, (EntityPlayerMP)player);
    }

    public void sendToAllAround(IMessage message, World world, double x, double y, double z, double distance) {
        this.sendToAllAround(message, new NetworkRegistry.TargetPoint(world.provider.dimensionId, x, y, z, distance));
    }

    public void sendToAllAround(IMessage message, World world, double x, double y, double z, double distance, EntityPlayer except) {
        for (EntityPlayer player : world.playerEntities) {
            double dz;
            double dy;
            double dx;
            if (player == except || !((dx = x - player.posX) * dx + (dy = y - player.posY) * dy + (dz = z - player.posZ) * dz < distance * distance)) continue;
            this.sendTo(message, player);
        }
    }

    public void sendToAllTracking(IMessage message, Entity entity) {
        ((WorldServer)entity.worldObj).getEntityTracker().func_151247_a(entity, this.getPacketFrom(message));
    }

    public void sendToAndAllTracking(IMessage message, Entity entity) {
        this.sendToAllTracking(message, entity);
        if (entity instanceof EntityPlayer) {
            this.sendTo(message, (EntityPlayer)entity);
        }
    }
}

