/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.network.packet;

import java.io.IOException;
import net.mcft.copy.betterstorage.network.AbstractPacket;
import net.mcft.copy.betterstorage.utils.PlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class PacketOpenGui
extends AbstractPacket<PacketOpenGui> {
    public int windowId;
    public String name;
    public int columns;
    public int rows;
    public String title;

    public PacketOpenGui() {
    }

    public PacketOpenGui(int windowId, String name, int columns, int rows, String title) {
        this.windowId = windowId;
        this.name = name;
        this.columns = columns;
        this.rows = rows;
        this.title = title;
    }

    @Override
    public void encode(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.windowId);
        buffer.writeStringToBuffer(this.name);
        buffer.writeByte(this.columns);
        buffer.writeByte(this.rows);
        buffer.writeStringToBuffer(this.title);
    }

    @Override
    public void decode(PacketBuffer buffer) throws IOException {
        this.windowId = buffer.readInt();
        this.name = buffer.readStringFromBuffer(256);
        this.columns = buffer.readByte();
        this.rows = buffer.readByte();
        this.title = buffer.readStringFromBuffer(256);
    }

    @Override
    public void handle(EntityPlayer player) {
        PlayerUtils.openGui(player, this.name, this.columns, this.rows, this.title);
        player.openContainer.windowId = this.windowId;
    }
}

