/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.proxy.ClientProxy;
import net.mcft.copy.betterstorage.tile.TileContainerBetterStorage;
import net.mcft.copy.betterstorage.tile.entity.TileEntityBackpack;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileBackpack
extends TileContainerBetterStorage {
    boolean lastSneaking = false;
    private long lastHelpMessage = System.currentTimeMillis();

    public TileBackpack() {
        super(Material.cloth);
        this.setHardness(1.5f);
        this.setStepSound(soundTypeCloth);
        float w = (float)this.getBoundsWidth() / 16.0f;
        float h = (float)this.getBoundsHeight() / 16.0f;
        this.setBlockBounds(0.5f - w / 2.0f, 0.0f, 0.5f - w / 2.0f, 0.5f + w / 2.0f, h, 0.5f + w / 2.0f);
    }

    public int getBoundsWidth() {
        return 12;
    }

    public int getBoundsHeight() {
        return 13;
    }

    public int getBoundsDepth() {
        return 10;
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return null;
    }

    public ItemBackpack getItemType() {
        return BetterStorageItems.itemBackpack;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon("wool_colored_brown");
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        float w = (float)this.getBoundsWidth() / 16.0f;
        float h = (float)this.getBoundsHeight() / 16.0f;
        float d = (float)this.getBoundsDepth() / 16.0f;
        ForgeDirection orientation = ForgeDirection.getOrientation((int)world.getBlockMetadata(x, y, z));
        if (orientation == ForgeDirection.NORTH || orientation == ForgeDirection.SOUTH) {
            this.setBlockBounds(0.5f - w / 2.0f, 0.0f, 0.5f - d / 2.0f, 0.5f + w / 2.0f, h, 0.5f + d / 2.0f);
        } else if (orientation == ForgeDirection.WEST || orientation == ForgeDirection.EAST) {
            this.setBlockBounds(0.5f - d / 2.0f, 0.0f, 0.5f - w / 2.0f, 0.5f + d / 2.0f, h, 0.5f + w / 2.0f);
        } else {
            this.setBlockBounds(0.5f - w / 2.0f, 0.0f, 0.5f - w / 2.0f, 0.5f + w / 2.0f, h, 0.5f + w / 2.0f);
        }
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderType() {
        return ClientProxy.backpackRenderId;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 0;
    }

    public float getPlayerRelativeBlockHardness(EntityPlayer player, World world, int x, int y, int z) {
        float hardness = super.getPlayerRelativeBlockHardness(player, world, x, y, z);
        boolean sneaking = player.isSneaking();
        boolean canEquip = ItemBackpack.canEquipBackpack(player);
        boolean stoppedSneaking = this.localPlayerStoppedSneaking(player);
        return stoppedSneaking || sneaking && !canEquip ? -1.0f : hardness * (float)(sneaking ? 4 : 1);
    }

    private boolean localPlayerStoppedSneaking(EntityPlayer player) {
        if (!player.worldObj.isRemote || player != Minecraft.getMinecraft().thePlayer) {
            return false;
        }
        boolean stoppedSneaking = !player.isSneaking() && this.lastSneaking;
        this.lastSneaking = player.isSneaking();
        return stoppedSneaking;
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        if (world.isRemote && player.isSneaking() && !ItemBackpack.canEquipBackpack(player) && BetterStorage.globalConfig.getBoolean("general.enableHelpTooltips") && System.currentTimeMillis() > this.lastHelpMessage + 10000L) {
            boolean backpack = ItemBackpack.getBackpack((EntityLivingBase)player) != null;
            player.addChatMessage((IChatComponent)new ChatComponentTranslation("tile.betterstorage.backpack.cantEquip." + (backpack ? "backpack" : "chestplate"), new Object[0]));
            this.lastHelpMessage = System.currentTimeMillis();
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityBackpack();
    }
}

