/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile;

import net.mcft.copy.betterstorage.attachment.IHasAttachments;
import net.mcft.copy.betterstorage.tile.TileBetterStorage;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TileContainerBetterStorage
extends TileBetterStorage {
    public boolean hasTileEntity(int metadata) {
        return true;
    }

    protected TileContainerBetterStorage(Material material) {
        super(material);
        this.isBlockContainer = true;
    }

    public boolean onBlockEventReceived(World world, int x, int y, int z, int eventId, int eventPar) {
        TileEntity te = world.getTileEntity(x, y, z);
        return te != null ? te.receiveClientEvent(eventId, eventPar) : false;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        this.getContainer(world, x, y, z).onBlockPlaced(player, stack);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return this.getContainer(world, x, y, z).onBlockActivated(player, side, hitX, hitY, hitZ);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!this.getContainer(world, x, y, z).onBlockBreak(player)) {
            return false;
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void onBlockPreDestroy(World world, int x, int y, int z, int meta) {
        TileEntityContainer container = this.getContainer(world, x, y, z);
        if (container != null) {
            container.onBlockDestroyed();
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack pick;
        TileEntityContainer container = this.getContainer(world, x, y, z);
        if (container instanceof IHasAttachments && (pick = ((IHasAttachments)((Object)container)).getAttachments().pick(target)) != null) {
            return pick;
        }
        pick = super.getPickBlock(target, world, x, y, z);
        return container.onPickBlock(pick, target);
    }

    public int getComparatorInputOverride(World world, int x, int y, int z, int direction) {
        return TileEntityContainer.getContainerComparatorSignalStrength((IBlockAccess)world, x, y, z);
    }

    private TileEntityContainer getContainer(World world, int x, int y, int z) {
        return WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityContainer.class);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighborBlock) {
        TileEntityContainer container = this.getContainer(world, x, y, z);
        if (container != null) {
            container.onNeighborUpdate(neighborBlock);
        }
    }
}

