/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.mcft.copy.betterstorage.api.BetterStorageEnchantment;
import net.mcft.copy.betterstorage.attachment.Attachments;
import net.mcft.copy.betterstorage.attachment.EnumAttachmentInteraction;
import net.mcft.copy.betterstorage.attachment.IHasAttachments;
import net.mcft.copy.betterstorage.proxy.ClientProxy;
import net.mcft.copy.betterstorage.tile.TileBetterStorage;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLockableDoor;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileLockableDoor
extends TileBetterStorage {
    private IIcon iconUpper;
    private IIcon iconLower;
    private IIcon iconUpperFlipped;
    private IIcon iconLowerFlipped;

    public TileLockableDoor() {
        super(Material.wood);
        this.setCreativeTab(null);
        this.setHardness(8.0f);
        this.setResistance(20.0f);
        this.setStepSound(soundTypeWood);
        this.setHarvestLevel("axe", 2);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        float offset = metadata == 0 ? 0.0f : -1.0f;
        TileEntityLockableDoor te = WorldUtils.get(world, x, y + (int)offset, z, TileEntityLockableDoor.class);
        if (te == null) {
            return;
        }
        switch (te.orientation) {
            case WEST: {
                if (te.isOpen) {
                    this.setBlockBounds(0.0f, 0.0f, 3.125E-4f, 1.0f, 1.0f, 0.1871875f);
                    break;
                }
                this.setBlockBounds(3.125E-4f, 0.0f, 0.0f, 0.1871875f, 1.0f, 1.0f);
                break;
            }
            case EAST: {
                if (te.isOpen) {
                    this.setBlockBounds(0.0f, 0.0f, 0.8128125f, 1.0f, 1.0f, 0.9996875f);
                    break;
                }
                this.setBlockBounds(0.8128125f, 0.0f, 0.0f, 0.9996875f, 1.0f, 1.0f);
                break;
            }
            case SOUTH: {
                if (te.isOpen) {
                    this.setBlockBounds(3.125E-4f, 0.0f, 0.0f, 0.1871875f, 1.0f, 1.0f);
                    break;
                }
                this.setBlockBounds(0.0f, 0.0f, 0.8128125f, 1.0f, 1.0f, 0.9996875f);
                break;
            }
            default: {
                if (te.isOpen) {
                    this.setBlockBounds(0.8128125f, 0.0f, 0.0f, 0.9996875f, 1.0f, 1.0f);
                    break;
                }
                this.setBlockBounds(0.0f, 0.0f, 3.125E-4f, 1.0f, 1.0f, 0.1871875f);
            }
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.iconUpper = iconRegister.registerIcon("door_iron_upper");
        this.iconLower = iconRegister.registerIcon("door_iron_lower");
        this.iconUpperFlipped = new IconFlipped(this.iconUpper, true, false);
        this.iconLowerFlipped = new IconFlipped(this.iconLower, true, false);
        this.blockIcon = this.iconUpper;
    }

    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int face) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta > 0) {
            --y;
        }
        TileEntityLockableDoor lockable = WorldUtils.get(world, x, y, z, TileEntityLockableDoor.class);
        boolean flip = false;
        IIcon icon = this.iconUpper;
        if (meta == 0 || face == 1) {
            icon = this.iconLower;
        }
        switch (lockable.orientation) {
            case WEST: {
                if (face == 3 && !lockable.isOpen) {
                    flip = true;
                    break;
                }
                if (face != 2 || !lockable.isOpen) break;
                flip = true;
                break;
            }
            case EAST: {
                if (face == 4 && !lockable.isOpen) {
                    flip = true;
                    break;
                }
                if (face != 3 || !lockable.isOpen) break;
                flip = true;
                break;
            }
            case SOUTH: {
                if (face == 2 && !lockable.isOpen) {
                    flip = true;
                    break;
                }
                if (face != 4 || !lockable.isOpen) break;
                flip = true;
                break;
            }
            default: {
                if (face == 3 && !lockable.isOpen) {
                    flip = true;
                    break;
                }
                if (face != 5 || !lockable.isOpen) break;
                flip = true;
            }
        }
        icon = flip ? (icon == this.iconLower ? this.iconLowerFlipped : this.iconUpperFlipped) : icon;
        return icon;
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        TileEntityLockableDoor lockable;
        if (world.getBlockMetadata(x, y, z) > 0) {
            --y;
        }
        if ((lockable = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockableDoor.class)) != null && lockable.getLock() != null) {
            return -1.0f;
        }
        return super.getBlockHardness(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int persistance;
        if (world.getBlockMetadata(x, y, z) > 0) {
            --y;
        }
        float modifier = 1.0f;
        TileEntityLockableDoor lockable = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockableDoor.class);
        if (lockable != null && (persistance = BetterStorageEnchantment.getLevel(lockable.getLock(), "persistance")) > 0) {
            modifier = (float)((double)modifier + Math.pow(2.0, persistance));
        }
        return super.getExplosionResistance(entity) * modifier;
    }

    public boolean onBlockEventReceived(World world, int x, int y, int z, int eventId, int eventPar) {
        TileEntity te = world.getTileEntity(x, y, z);
        return te != null ? te.receiveClientEvent(eventId, eventPar) : false;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.getBlockMetadata(x, y, z) > 0) {
            --y;
        }
        TileEntityLockableDoor te = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockableDoor.class);
        return te.onBlockActivated(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        if (world.getBlockMetadata(x, y, z) > 0) {
            --y;
        }
        Attachments attachments = WorldUtils.get((IBlockAccess)world, x, y, z, IHasAttachments.class).getAttachments();
        boolean abort = attachments.interact(WorldUtils.rayTrace(player, 1.0f), player, EnumAttachmentInteraction.attack);
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        int metadata = world.getBlockMetadata(x, y, z);
        IHasAttachments te = WorldUtils.get((IBlockAccess)world, x, y - (metadata > 0 ? 1 : 0), z, IHasAttachments.class);
        if (te == null) {
            return super.collisionRayTrace(world, x, y, z, start, end);
        }
        MovingObjectPosition pos = te.getAttachments().rayTrace(world, x, y - (metadata > 0 ? 1 : 0), z, start, end);
        return pos != null ? pos : super.collisionRayTrace(world, x, y, z, start, end);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack(Items.iron_door);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return world.setBlockToAir(x, y, z);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        if (meta > 0) {
            return;
        }
        super.breakBlock(world, x, y, z, block, meta);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        int targetMeta;
        int metadata = world.getBlockMetadata(x, y, z);
        int targetY = y + (metadata == 0 ? 1 : -1);
        int n = targetMeta = metadata == 0 ? 8 : 0;
        if (world.getBlock(x, y - 1, z) == Blocks.air && metadata == 0) {
            world.setBlockToAir(x, y, z);
        }
        if (world.getBlock(x, targetY, z) == this && world.getBlockMetadata(x, targetY, z) == targetMeta) {
            return;
        }
        world.setBlockToAir(x, y, z);
        if (metadata == 0) {
            WorldUtils.spawnItem(world, x, y, z, new ItemStack(Items.iron_door));
        }
    }

    public void onBlockPreDestroy(World world, int x, int y, int z, int meta) {
        if (meta == 0) {
            TileEntityLockableDoor te = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockableDoor.class);
            WorldUtils.dropStackFromBlock(te, te.getLock());
            te.setLockWithUpdate(null);
        }
        super.onBlockPreDestroy(world, x, y, z, meta);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderType() {
        return ClientProxy.lockableDoorRenderId;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return meta == 0 ? 1 : 0;
    }

    public boolean canProvidePower() {
        return true;
    }

    public int isProvidingWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityLockableDoor te;
        if (world.getBlockMetadata(x, y, z) > 0) {
            --y;
        }
        return (te = WorldUtils.get(world, x, y, z, TileEntityLockableDoor.class)) == null ? 0 : (te.isPowered() ? 15 : 0);
    }

    public int isProvidingStrongPower(IBlockAccess world, int x, int y, int z, int side) {
        return this.isProvidingWeakPower(world, x, y, z, side);
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
        if (world.getBlockMetadata(x, y, z) != 0) {
            return;
        }
        WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockableDoor.class).setPowered(false);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return metadata == 0 ? new TileEntityLockableDoor() : null;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }
}

